/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.konfigurationsdaten.KdRdsLandesKennung.Daten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsLandesKennung;

/**
 * Wrapper, welcher für ein RdsQuantitaet-SystemObjekt sämtliche Daten vorhält.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * 
 * @see RdsLandesKennung
 */
public class RdsLandesKennungWrapper {

	/** Das Land. */
	private String land;

	/** Der Code. */
	private String landesCode;

	/**
	 * Der Default-Konstruktor.
	 */
	public RdsLandesKennungWrapper() {
		land = "unbekannt";
		landesCode = "unbekannt";
	}

	/**
	 * Der Konstruktor.
	 * 
	 * @param rdsLandesKennung die RDS-Quantitaet, darf nicht <code>null</code> sein
	 */
	public RdsLandesKennungWrapper(final RdsLandesKennung rdsLandesKennung) {
		assert rdsLandesKennung.getKdRdsLandesKennung() != null;
		assert rdsLandesKennung.getKdRdsLandesKennung().getDatum() != null;

		final Daten datum = rdsLandesKennung.getKdRdsLandesKennung().getDatum();
		land = datum.getLand();
		landesCode = datum.getLandescode();
	}

	/**
	 * Liefert das Land dieser Landeskennung zurück.
	 * 
	 * @return das Land dieser Landeskennung
	 */
	public String getLand() {
		return land;
	}

	/**
	 * Setzt das Land dieser Landeskennung.
	 * 
	 * @param neuerWert das neue Land
	 */
	public void setLand(final String neuerWert) {
		land = neuerWert;
	}

	/**
	 * Liefert den Landescode dieser Landeskennung zurück.
	 * 
	 * @return den Landescode dieser Landeskennung
	 */
	public String getLandesCode() {
		return landesCode;
	}

	/**
	 * Setzt den Landescode dieser Landeskennung.
	 * 
	 * @param neuerWert der neue Landescode
	 */
	public void setLandesCode(final String neuerWert) {
		landesCode = neuerWert;
	}

	@Override
	public String toString() {
		return new StringBuffer(getLand()).append(" (").append(getLandesCode()).append(")").toString();
	}

	@Override
	public int hashCode() {
		return toString().hashCode();
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		return toString().equals(obj.toString());
	}
}
