/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt.Daten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcGebiet;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcLinie;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcPunkt;

/**
 * Wrapper, welcher für ein TmcPunkt-SystemObjekt sämtliche Daten vorhält.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * 
 * @see TmcPunkt
 */
public class TmcPunktWrapper extends TmcLocationCodeWrapper {

	/** Der in diesem Wrapper gekapselte TmcPunkt. */
	private final TmcPunkt tmcPunkt;

	/** Das zu dem gekapseltem TmcPunkt gehörige Datum. */
	private final Daten datum;

	/**
	 * Der Konstruktor.
	 * 
	 * @param tmcPunkt der TMC-Punkt, darf nicht <code>null</code> sein
	 */
	public TmcPunktWrapper(final TmcPunkt tmcPunkt) {
		super(tmcPunkt);
		assert tmcPunkt.getKdTmcPunkt() != null;
		assert tmcPunkt.getKdTmcPunkt().getDatum() != null;

		this.tmcPunkt = tmcPunkt;
		datum = tmcPunkt.getKdTmcPunkt().getDatum();
	}

	/**
	 * Liefert das in diesem Objekt gekapselte TmcPunkt-Systemobjekt zurück.
	 * 
	 * @return das in diesem Objekt gekapselte TmcPunkt-Systemobjekt, niemals
	 *         <code>null</code>
	 */
	public TmcPunkt getTmcPunkt() {
		return tmcPunkt;
	}

	/**
	 * Attribut zur Referenzierung des Objekttyps: typ.tmcGebiet (Optionale
	 * Referenzierung erlaubt).
	 * 
	 * @return der Wert von IstTeilvonTmcGebiet
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt.Daten#getIstTeilvonTmcGebiet()
	 */
	public TmcGebiet getIstTeilvonTmcGebiet() {
		return datum.getIstTeilvonTmcGebiet();
	}

	/**
	 * Attribut zur Referenzierung des Objekttyps: typ.tmcLinie (Optionale
	 * Referenzierung erlaubt).
	 * 
	 * @return der Wert von IstTeilvonTmcLinie
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt.Daten#getIstTeilvonTmcLinie()
	 */
	public TmcLinie getIstTeilvonTmcLinie() {
		return datum.getIstTeilvonTmcLinie();
	}

	/**
	 * Attribut zur Referenzierung des Objekttyps: typ.tmcPunkt (Optionale
	 * Referenzierung erlaubt).
	 * 
	 * @return der Wert von Kreuzung
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt.Daten#getKreuzung()
	 */
	public TmcPunkt getKreuzung() {
		return datum.getKreuzung();
	}

	/**
	 * Attribut zur Referenzierung des Objekttyps: typ.tmcPunkt (Optionale
	 * Referenzierung erlaubt).
	 * 
	 * @return der Wert von Nachfolger
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt.Daten#getNachfolger()
	 */
	public TmcPunkt getNachfolger() {
		return datum.getNachfolger();
	}

	/**
	 * Attribut zur Referenzierung des Objekttyps: typ.tmcPunkt (Optionale
	 * Referenzierung erlaubt).
	 * 
	 * @return der Wert von Vorgaenger
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcPunkt.Daten#getVorgaenger()
	 */
	public TmcPunkt getVorgaenger() {
		return datum.getVorgaenger();
	}
}
