/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

/**
 * Laedt bestimmte Konfigurationsdaten auf einen Schlag vor und fuellt so den
 * lokalen DAV-Client-Puffer.
 * 
 * @author BitCtrl Systems GmbH, thierfelder
 * @version $Id$
 */
public final class DavCacheLader {

	private static final boolean KAPPICH_HAT_DAS_NEUE_BESCHLEUNIGUNGS_FEATURE_EINGEBAUT = false;

	private static final Set<SystemObjectTypUndAtg> ALREADY_LOADED = Collections
			.synchronizedSet(new TreeSet<SystemObjectTypUndAtg>());

	/**
	 * Laedt bestimmte Konfigurationsdaten auf einen Schlag vor und fuellt so den
	 * lokalen DAV-Client-Puffer.
	 * 
	 * @param dav     Verbindung zum Datenverteiler.
	 * @param typePid die PID des {@link SystemObjectType}, fuer dessen Objekte
	 *                Daten geladen werden sollen.
	 * @param atgPid  die PID der {@link AttributeGroup}, deren Daten geladen werden
	 *                sollen.
	 */
	public static void lade(final ClientDavInterface dav, final String typePid, final String atgPid) {
		if (!KAPPICH_HAT_DAS_NEUE_BESCHLEUNIGUNGS_FEATURE_EINGEBAUT) {
			return;
		}
		final SystemObjectType type = dav.getDataModel().getType(typePid);
		final AttributeGroup atg = dav.getDataModel().getAttributeGroup(atgPid);
		final SystemObjectTypUndAtg dummy = new SystemObjectTypUndAtg(type, atg);
		if (ALREADY_LOADED.add(dummy)) {
			dav.getDataModel().getConfigurationData(type.getElements(), atg);
		}
	}

	/**
	 * Eindeutige Kombination aus {@link SystemObject} und {@link AttributeGroup}.
	 * 
	 * @author BitCtrl Systems GmbH, thierfelder
	 * @version $Id$
	 */
	private static final class SystemObjectTypUndAtg implements Comparable<SystemObjectTypUndAtg> {

		private final Long typeId;

		private final Long atgId;

		private SystemObjectTypUndAtg(final SystemObjectType type, final AttributeGroup atg) {
			typeId = type.getId();
			atgId = atg.getId();
		}

		@Override
		public int compareTo(final SystemObjectTypUndAtg that) {
			int comp = typeId.compareTo(that.typeId);
			if (comp == 0) {
				comp = atgId.compareTo(that.atgId);
			}
			return comp;
		}

		@Override
		public boolean equals(final Object obj) {
			if (obj == null) {
				return false;
			}
			if(obj instanceof SystemObjectTypUndAtg) {
				return compareTo((SystemObjectTypUndAtg) obj) == 0;
			}
			return false;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((atgId == null) ? 0 : atgId.hashCode());
			result = prime * result + ((typeId == null) ? 0 : typeId.hashCode());
			return result;
		}

	}

}
