/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util;

import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.objekte.AutarkeOrganisationsEinheit;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer;
import de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler;

/**
 * Hilfsklasse für das Kappich-Modell.
 * 
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @version $Id$
 */
public final class KappichModellUtil {

	/**
	 * Gibt die autarke Organisationseinheit zurück.
	 * 
	 * @param factory die Factory von der die AOE gesucht wird.
	 * @return die AOE.
	 */
	public static AutarkeOrganisationsEinheit getAOE(final ObjektFactory factory) {
		return (AutarkeOrganisationsEinheit) factory.getModellobjekt(factory.getDav().getLocalConfigurationAuthority());
	}

	/**
	 * Gibt die lokale Klientapplikation zurück.
	 * 
	 * @param factory die Factory von der die Klientapplikation gesucht wird.
	 * @return die lokale Applikation.
	 */
	public static Applikation getApplikation(final ObjektFactory factory) {
		return (Applikation) factory.getModellobjekt(factory.getDav().getLocalApplicationObject());
	}

	/**
	 * Gibt den Datenverteiler zurück, mit dem die lokale Applikation verbunden ist.
	 * 
	 * @param factory die Factory von der der lokale Datenverteiler gesucht wird.
	 * @return der Datenverteiler.
	 */
	public static Datenverteiler getDatenverteiler(final ObjektFactory factory) {
		return (Datenverteiler) factory.getModellobjekt(factory.getDav().getLocalDav());
	}

	/**
	 * Gibt den angemeldeten Benutzer für die lokale Applikation zurück.
	 * 
	 * @param factory die Factory von der der lokale Benutzer gesucht wird.
	 * @return der lokale Benutzer.
	 */
	public static Benutzer getBenutzer(final ObjektFactory factory) {
		return (Benutzer) factory.getModellobjekt(factory.getDav().getLocalUser());
	}

	/**
	 * Konvertiert einen boolschen von Datenverteiler in Model.
	 * 
	 * @param jaNein ein boolscher Wert im Datenverteiler.
	 * @return der boolsche Wert im Modell.
	 */
	public static boolean konvertiereBool(final AttJaNein jaNein) {
		return AttJaNein.ZUSTAND_1_JA.equals(jaNein);
	}

	/**
	 * Konvertiert einen boolschen Wert von Model in Datenverteiler.
	 * 
	 * @param bool ein boolscher Wert im Model.
	 * @return der boolsche Wert im Datenverteiler.
	 */
	public static AttJaNein konvertiereBool(final boolean bool) {
		if (bool) {
			return AttJaNein.ZUSTAND_1_JA;
		}
		return AttJaNein.ZUSTAND_0_NEIN;
	}

	private KappichModellUtil() {
		// Es sind keine Instanzen der Utility-Klasse erlaubt.
	}

}
