/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util;

import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum.Status;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Feld;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.AeusseresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenKnoten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.parameter.PdSituationsEigenschaften.Daten;

/**
 * Funktionen zum Ermitteln von Daten aus Situations-Objekten.
 * 
 * @author BitCtrl Systems GmbH, Uwe Peuker
 * @version $Id$
 */
public final class SituationUtil {

	/** Konstruktor. */
	private SituationUtil() {
		// es gibt keine Instanzen dieser Klasse.
	}

	public static Strasse getStrasse(final Daten daten) {
		Strasse result = null;
		if ((daten != null) && (daten.dGetDatenStatus() == Status.DATEN)) {
			final Feld<StrassenSegment> segmente = daten.getStrassenSegment();
			for (final StrassenSegment seg : segmente) {
				final de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment.Daten segmentDaten = seg
						.getKdStrassenSegment().getDatum();
				if (segmentDaten != null) {
					result = segmentDaten.getGehoertZuStrasse();
				}
				if (result != null) {
					break;
				}
			}
		}
		return result;
	}

	public static StrassenKnoten getVonKnoten(final Daten daten) {

		StrassenKnoten result = null;

		if ((daten != null) && (daten.dGetDatenStatus() == Status.DATEN)) {
			final Feld<StrassenSegment> segmentListe = daten.getStrassenSegment();
			if (!segmentListe.isEmpty()) {
				final StrassenSegment segment = segmentListe.get(0);

				if (segment instanceof InneresStrassenSegment) {

					final InneresStrassenSegment iss = (InneresStrassenSegment) segment;
					final AeusseresStrassenSegment vonSegment = iss.getKdInneresStrassenSegment().getDatum()
							.getVonStrassenSegment();
					if (vonSegment != null) {
						result = vonSegment.getKdAeusseresStrassenSegment().getDatum().getVonKnoten();
					}

					if (result == null) {
						if (vonSegment != null) {
							result = vonSegment.getKdAeusseresStrassenSegment().getDatum().getNachKnoten();
						}
					}
				} else if (segment instanceof AeusseresStrassenSegment) {

					final StrassenKnoten knoten = ((AeusseresStrassenSegment) segment).getKdAeusseresStrassenSegment()
							.getDatum().getVonKnoten();
					if (knoten != null) {
						result = knoten;
					}
				}

			}
		}

		return result;
	}

	public static StrassenKnoten getFolgeKnoten(final Daten daten) {
		StrassenKnoten result = null;

		if ((daten != null) && (daten.dGetDatenStatus() == Status.DATEN)) {
			final Feld<StrassenSegment> segmentListe = daten.getStrassenSegment();
			if (!segmentListe.isEmpty()) {
				final StrassenSegment segment = segmentListe.get(segmentListe.size() - 1);
				if (segment instanceof InneresStrassenSegment) {
					final InneresStrassenSegment iss = (InneresStrassenSegment) segment;
					final AeusseresStrassenSegment nachSegment = iss.getKdInneresStrassenSegment().getDatum()
							.getNachStrassenSegment();

					if (nachSegment != null) {
						result = nachSegment.getKdAeusseresStrassenSegment().getDatum().getNachKnoten();
					}
					if (result == null) {
						if (nachSegment != null) {
							result = nachSegment.getKdAeusseresStrassenSegment().getDatum().getVonKnoten();
						}
					}
				} else if (segment instanceof AeusseresStrassenSegment) {
					final StrassenKnoten knoten = ((AeusseresStrassenSegment) segment).getKdAeusseresStrassenSegment()
							.getDatum().getNachKnoten();
					if (knoten != null) {
						result = knoten;
					}
				}
			}
		}
		return result;
	}
}
