/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.util.benutzer;

/**
 * Diese Ausnahme zeigt an, dass ein Benutzer nicht erfolgreich angelegt,
 * gelöscht oder geändert werden konnte.
 * 
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class BenutzerChangeException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * Konstruktor ohne Meldungstext und vorangegangende Fehler.
	 */
	public BenutzerChangeException() {
		// nix zu tun
	}

	/**
	 * Konstruktor mit Meldungstext.
	 * 
	 * @param message der Meldungstext.
	 */
	public BenutzerChangeException(final String message) {
		super(message);
	}

	/**
	 * Konstruktor mit vorangegangende Fehler.
	 * 
	 * @param cause der vorangegangende Fehler.
	 */
	public BenutzerChangeException(final Throwable cause) {
		super(cause);
	}

	/**
	 * Konstruktor mit Meldungstext und vorangegangende Fehler.
	 * 
	 * @param message der Meldungstext.
	 * @param cause   der vorangegangende Fehler.
	 */
	public BenutzerChangeException(final String message, final Throwable cause) {
		super(message, cause);
	}

}
