/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.comparator;

import java.io.Serializable;
import java.util.Comparator;

import de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.InneresStrassenSegment;

/**
 * Comparator zum Vergleichen/Sortieren von inneren Straßensegmenten.
 * 
 * <p>
 * Beim Vergleich von zwei inneren Straßensegmente wird zuerst die
 * Hauptfahrbeziehung berücksichtigt, danach ggf. die Länge des Straßensegments
 * und abschließend ggf. die PID.
 * </p>
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public class InnereSegmenteComparator implements Comparator<InneresStrassenSegment>, Serializable {

	private static final long serialVersionUID = 1L;

	@Override
	public int compare(final InneresStrassenSegment o1, final InneresStrassenSegment o2) {

		// (1) Überprüfe Hauptfahrbeziehung
		final de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegmentHauptFahrBeziehung.Daten hfbDatum1 = o1
				.getKdInneresStrassenSegmentHauptFahrBeziehung().getDatum();
		final de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdInneresStrassenSegmentHauptFahrBeziehung.Daten hfbDatum2 = o2
				.getKdInneresStrassenSegmentHauptFahrBeziehung().getDatum();
		if ((hfbDatum1 != null) && (hfbDatum2 != null)) {
			final boolean durchgehend1 = hfbDatum1.getDurchgehendeHauptFahrBeziehung() == AttJaNein.ZUSTAND_1_JA;
			final boolean durchgehend2 = hfbDatum2.getDurchgehendeHauptFahrBeziehung() == AttJaNein.ZUSTAND_1_JA;
			if (durchgehend1 && !durchgehend2) {
				return -1;
			}
			if (!durchgehend1 && durchgehend2) {
				return 1;
			}
		}

		// (2) Überprüfe Länge
		final de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment.Daten strDatum1 = o1
				.getKdStrassenSegment().getDatum();
		final de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment.Daten strDatum2 = o2
				.getKdStrassenSegment().getDatum();
		if ((strDatum1 != null) && (strDatum2 != null)) {
			final Double laenge1 = strDatum1.getLaenge().getValue();
			final Double laenge2 = strDatum2.getLaenge().getValue();
			final int compare = laenge1.compareTo(laenge2);
			if (compare != 0) {
				return compare;
			}
		}

		// (3) Überprüfe PID
		return o1.getPid().compareTo(o2.getPid());
	}
}
