/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;

/**
 * Abstrakte Superklasse für sämtliche Wrapper-Klassen. Diese Klasse stellt die
 * PropertyChangeListener-Infrastruktur zur Verfügung.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public class AbstractWrapper {

	/** Der Property-Change-Support. */
	private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

	/**
	 * Fügt diesem Wrapper einen neuen PropertyChangeListener hinzu.
	 * 
	 * @param listener der Listener
	 * 
	 * @see PropertyChangeSupport#addPropertyChangeListener(PropertyChangeListener)
	 */
	public void addPropertyChangeListener(final PropertyChangeListener listener) {
		changeSupport.addPropertyChangeListener(listener);
	}

	/**
	 * Fügt diesem Wrapper einen neuen PropertyChangeListener hinzu.
	 * 
	 * @param propertyName der Name der Property
	 * @param listener     der Listener
	 * 
	 * @see PropertyChangeSupport#addPropertyChangeListener(String,
	 *      PropertyChangeListener)
	 */
	public void addPropertyChangeListener(final String propertyName, final PropertyChangeListener listener) {
		if (!Arrays.asList(changeSupport.getPropertyChangeListeners(propertyName)).contains(listener)) {
			changeSupport.addPropertyChangeListener(propertyName, listener);
		}
	}

	/**
	 * Entfernt den gegebenen PropertyChangeListener von diesem Wrapper.
	 * 
	 * @param propertyName der Name der Property
	 * @param listener     der Listener
	 * 
	 * @see PropertyChangeSupport#removePropertyChangeListener(String,
	 *      PropertyChangeListener)
	 */
	public void removePropertyChangeListener(final String propertyName, final PropertyChangeListener listener) {
		changeSupport.removePropertyChangeListener(propertyName, listener);
	}

	/**
	 * Informiert alle registrierten PropertyChangeListener über eine Änderung.
	 * 
	 * @param propertyName der Name der Property
	 * @param oldValue     der alter Wert
	 * @param newValue     der neue Wert
	 * 
	 * @see PropertyChangeSupport#firePropertyChange(String, Object, Object)
	 */
	protected void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
		changeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}
}
