/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

/**
 * Diese Enumeration modelliert die gültigen Werte für die Ereignis-Quantität
 * LEN (betroffene Länge in km).
 *
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public enum BetroffeneLaenge {

	/** 1 km. */
	KM_1("1"),
	/** 2 km. */
	KM_2("2"),
	/** 3 km. */
	KM_3("3"),
	/** 4 km. */
	KM_4("4"),
	/** 5 km. */
	KM_5("5"),
	/** 6 km. */
	KM_6("6"),
	/** 7 km. */
	KM_7("7"),
	/** 8 km. */
	KM_8("8"),
	/** 9 km. */
	KM_9("9"),
	/** 10 km. */
	KM_10("10"),
	/** 12 km. */
	KM_12("12"),
	/** 14 km. */
	KM_14("14"),
	/** 16 km. */
	KM_16("16"),
	/** 18 km. */
	KM_18("18"),
	/** 20 km. */
	KM_20("20"),
	/** 25 km. */
	KM_25("25"),
	/** 30 km. */
	KM_30("30"),
	/** 35 km. */
	KM_35("35"),
	/** 40 km. */
	KM_40("40"),
	/** 45 km. */
	KM_45("45"),
	/** 50 km. */
	KM_50("50"),
	/** 55 km. */
	KM_55("55"),
	/** 60 km. */
	KM_60("60"),
	/** 65 km. */
	KM_65("65"),
	/** 70 km. */
	KM_70("70"),
	/** 75 km. */
	KM_75("75"),
	/** 80 km. */
	KM_80("80"),
	/** 85 km. */
	KM_85("85"),
	/** 90 km. */
	KM_90("90"),
	/** 95 km. */
	KM_95("95"),
	/** 100 km. */
	KM_100("100"),
	/** &gt;100 km. */
	KM_100_PLUS("> 100");

	/**
	 * Die Kennung der mit dieser Enumeration assoziierten Quantität.
	 */
	public static final String KENNUNG = QuantitaetenUtil.KENNUNG_BETROFFENE_LAENGE;

	/** Der Text. */
	private String text;

	/**
	 * Der private Konstruktor.
	 *
	 * @param text der Text
	 */
	BetroffeneLaenge(final String text) {
		this.text = text;
	}

	/**
	 * Liefert zu dem gegebenen Wert die entsprechende Enum-Instanz zurück.
	 *
	 * @param wert der Wert
	 *
	 * @return die entsprechende Enum-Instanz zu dem gegebenen Wert, kann
	 *         <code>null</code> sein
	 */
	public static BetroffeneLaenge getValue(final String wert) {
		final String s = wert.trim().toLowerCase().replaceAll("km", "");

		if (KM_100_PLUS.toString().equals(s)) {
			return KM_100_PLUS;
		}

		double d = -1;
		try {
			d = new Double(s);
		} catch (final NumberFormatException e) {
			// tut nix
		}

		if ((d >= 0) && (d < 1.5)) {
			return KM_1;
		} else if ((d >= 1.5) && (d < 2.5)) {
			return KM_2;
		} else if ((d >= 2.5) && (d < 3.5)) {
			return KM_3;
		} else if ((d >= 3.5) && (d < 4.5)) {
			return KM_4;
		} else if ((d >= 4.5) && (d < 5.5)) {
			return KM_5;
		} else if ((d >= 5.5) && (d < 6.5)) {
			return KM_6;
		} else if ((d >= 6.5) && (d < 7.5)) {
			return KM_7;
		} else if ((d >= 7.5) && (d < 8.5)) {
			return KM_8;
		} else if ((d >= 8.5) && (d < 9.5)) {
			return KM_9;
		} else if ((d >= 9.5) && (d < 11)) {
			return KM_10;
		} else if ((d >= 11) && (d < 13)) {
			return KM_12;
		} else if ((d >= 13) && (d < 15)) {
			return KM_14;
		} else if ((d >= 15) && (d < 17)) {
			return KM_16;
		} else if ((d >= 17) && (d < 19)) {
			return KM_18;
		} else if ((d >= 19) && (d < 22.5)) {
			return KM_20;
		} else if ((d >= 22.5) && (d < 27.5)) {
			return KM_25;
		} else if ((d >= 27.5) && (d < 32.5)) {
			return KM_30;
		} else if ((d >= 32.5) && (d < 37.5)) {
			return KM_35;
		} else if ((d >= 37.5) && (d < 42.5)) {
			return KM_40;
		} else if ((d >= 42.5) && (d < 47.5)) {
			return KM_45;
		} else if ((d >= 47.5) && (d < 52.5)) {
			return KM_50;
		} else if ((d >= 52.5) && (d < 57.5)) {
			return KM_55;
		} else if ((d >= 57.5) && (d < 62.5)) {
			return KM_60;
		} else if ((d >= 62.5) && (d < 67.5)) {
			return KM_65;
		} else if ((d >= 67.5) && (d < 72.5)) {
			return KM_70;
		} else if ((d >= 72.5) && (d < 77.5)) {
			return KM_75;
		} else if ((d >= 77.5) && (d < 82.5)) {
			return KM_80;
		} else if ((d >= 82.5) && (d < 87.5)) {
			return KM_85;
		} else if ((d >= 87.5) && (d < 92.5)) {
			return KM_90;
		} else if ((d >= 92.5) && (d < 97.5)) {
			return KM_95;
		} else if ((d >= 97.5) && (d < 100)) {
			return KM_100;
		} else if (d > 100) {
			return KM_100_PLUS;
		}
		return null;
	}

	@Override
	public String toString() {
		return text;
	}
}
