/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

/**
 * Definiert den Wertebereich (Minimalen und maximalen Wert) sowie die erlaubte
 * Schrittweite einer Quantität.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public class QuantitaetenWerteBereich {

	/** Der minimale Wert. */
	private final int min;

	/** Der maximale Wert. */
	private final int max;

	/** Die Anzahl der Nachkommastellen. */
	private final int digits;

	/** Die einfache Schrittweite. */
	private final int increment;

	/** Die erweiteret Schrittweite. */
	private final int pageIncrement;

	/** Der Standardwert. */
	private final int defaultValue;

	/**
	 * Der Konstruktor.
	 * 
	 * @param min           der minimale Wert
	 * @param max           der maximale Wert
	 * @param digits        die Anzahl der Nachkommastellen
	 * @param increment     die einfache Schrittweite
	 * @param pageIncrement die erweiterte Schrittweite
	 * @param defaultValue  der Standardwert
	 */
	public QuantitaetenWerteBereich(final int min, final int max, final int digits, final int increment,
			final int pageIncrement, final int defaultValue) {
		this.min = min;
		this.max = max;
		this.digits = digits;
		this.increment = increment;
		this.pageIncrement = pageIncrement;
		this.defaultValue = defaultValue;
	}

	/**
	 * Liefert den minimalen Wert zurück.
	 * 
	 * @return den minimalen Wert
	 */
	public int getMin() {
		return min;
	}

	/**
	 * Liefert den maximalen Wert zurück.
	 * 
	 * @return den maximalen Wert
	 */
	public int getMax() {
		return max;
	}

	/**
	 * Liefert die Anzahl der Nachkommastellen zurück.
	 * 
	 * @return die Anzahl der Nachkommastellen
	 */
	public int getDigits() {
		return digits;
	}

	/**
	 * Liefert die einfache Schrittweite zurück.
	 * 
	 * @return die einfache Schrittweite
	 */
	public int getIncrement() {
		return increment;
	}

	/**
	 * Liefert die erweiterte Schrittweite zurück.
	 * 
	 * @return die erweiterte Schrittweite
	 */
	public int getPageIncrement() {
		return pageIncrement;
	}

	/**
	 * Liefert den Standardwert zurück.
	 * 
	 * @return den Standardwert
	 */
	public int getDefaultValue() {
		return defaultValue;
	}
}
