/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import java.util.List;

/**
 * Listener, welcher über Änderungen der Landesmeldestellen bekannten
 * RDS-Meldungen informiert.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 */
public interface RdsMeldungenChangedListener {

	/**
	 * Informiert über neu hinzugefügte RDS-Meldungen.
	 * 
	 * @param rdsMeldungen die neu hinzugefügten RDS-Meldungen
	 */
	void rdsMeldungenAdded(List<RdsMeldungWrapper> rdsMeldungen);

	/**
	 * Informiert über entfernte RDS-Meldungen.
	 * 
	 * @param rdsMeldungen die entfernten RDS-Meldungen
	 */
	void rdsMeldungenRemoved(List<RdsMeldungWrapper> rdsMeldungen);

	/**
	 * Informiert über eine RDS-Meldung, deren Daten sich geändert haben.
	 * 
	 * @param neuerWert der neue EngstellenWrapper
	 * @param alterWert der alte EngstellenWrapper
	 */
	void rdsMeldungChanged(RdsMeldungWrapper neuerWert, RdsMeldungWrapper alterWert);
}
