/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.konfigurationsdaten.KdRdsQuantitaet.Daten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsQuantitaet;

/**
 * Wrapper, welcher für ein RdsQuantitaet-SystemObjekt sämtliche Daten vorhält.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * 
 * @see RdsQuantitaet
 */
public class RdsQuantitaetWrapper {

	/** Die in diesem Wrapper gekapselte {@link RdsQuantitaet}. */
	private final RdsQuantitaet rdsQuantitaet;

	/** Das zu der gekapselten {@link RdsQuantitaet} gehörige Datum. */
	private final Daten datum;

	/**
	 * Der Konstruktor.
	 * 
	 * @param rdsQuantitaet die RDS-Quantitaet, darf nicht <code>null</code> sein
	 */
	public RdsQuantitaetWrapper(final RdsQuantitaet rdsQuantitaet) {
		assert rdsQuantitaet.getKdRdsQuantitaet() != null;
		assert rdsQuantitaet.getKdRdsQuantitaet().getDatum() != null;

		this.rdsQuantitaet = rdsQuantitaet;
		datum = rdsQuantitaet.getKdRdsQuantitaet().getDatum();
	}

	/**
	 * Liefert das in diesem Objekt gekapselte {@link RdsQuantitaet} -Systemobjekt
	 * zurück.
	 * 
	 * @return das in diesem Objekt gekapselte {@link RdsQuantitaet} -Systemobjekt,
	 *         niemals <code>null</code>
	 */
	public RdsQuantitaet getRdsQuantiaet() {
		return rdsQuantitaet;
	}

	/**
	 * Liefert die Beschreibung dieser Quantität zurück.
	 * 
	 * @return die Beschreibung dieser Quantität
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.konfigurationsdaten.KdRdsQuantitaet.Daten#getBeschreibung()
	 */
	public String getBeschreibung() {
		return datum.getBeschreibung();
	}

	/**
	 * Liefert die Einheit dieser Quantität zurück.
	 * 
	 * @return die Einheit dieser Quantität
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.konfigurationsdaten.KdRdsQuantitaet.Daten#getEinheit()
	 */
	public String getEinheit() {
		return datum.getEinheit();
	}

	/**
	 * Liefert die Kennung dieser Quantität zurück.
	 * 
	 * @return die Kennung dieser Quantität
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.konfigurationsdaten.KdRdsQuantitaet.Daten#getKennung()
	 */
	public String getKennung() {
		return datum.getKennung();
	}

	@Override
	public String toString() {
		return getBeschreibung();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result;
		if (rdsQuantitaet != null) {
			result += rdsQuantitaet.getPid().hashCode();
		}
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final RdsQuantitaetWrapper other = (RdsQuantitaetWrapper) obj;
		if ((rdsQuantitaet == null) || (other.rdsQuantitaet == null)) {
			return false;
		}
		return rdsQuantitaet.getPid().equals(other.rdsQuantitaet.getPid());
	}
}
