/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.rdstmc;

import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcGebiet.Daten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.objekte.TmcGebiet;

/**
 * Wrapper, welcher für ein TmcGebiet-SystemObjekt sämtliche Daten vorhält.
 * 
 * @author BitCtrl Systems GmbH, Andreas Meissner
 * 
 * @see TmcGebiet
 */
public class TmcGebietWrapper extends TmcLocationCodeWrapper {

	/** Das in diesem Wrapper gekapselte TmcGebiet. */
	private final TmcGebiet tmcGebiet;

	/** Das zu dem gekapselten TmcGebiet gehörige Datum. */
	private final Daten datum;

	/**
	 * Der Konstruktor.
	 * 
	 * @param tmcGebiet die TMC-Gebiet, darf nicht <code>null</code> sein
	 */
	public TmcGebietWrapper(final TmcGebiet tmcGebiet) {
		super(tmcGebiet);
		assert tmcGebiet.getKdTmcGebiet() != null;
		assert tmcGebiet.getKdTmcGebiet().getDatum() != null;

		this.tmcGebiet = tmcGebiet;
		datum = tmcGebiet.getKdTmcGebiet().getDatum();
	}

	/**
	 * Liefert das in diesem Objekt gekapselte TmcGebiet-Systemobjekt zurück.
	 * 
	 * @return das in diesem Objekt gekapselte TmcGebiet-Systemobjekt, niemals
	 *         <code>null</code>
	 */
	public TmcGebiet getTmcGebiet() {
		return tmcGebiet;
	}

	/**
	 * Attribut zur Referenzierung des Objekttyps: typ.tmcGebiet (Optionale
	 * Referenzierung erlaubt).
	 * 
	 * @return der Wert von IstTeilvonTmcGebiet
	 * 
	 * @see de.bsvrz.sys.funclib.bitctrl.modell.tmtmcglobal.konfigurationsdaten.KdTmcGebiet.Daten#getIstTeilvonTmcGebiet()
	 */
	public TmcGebiet getIstTeilvonTmcGebiet() {
		return datum.getIstTeilvonTmcGebiet();
	}
}
