/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.test;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import de.bsvrz.sys.funclib.bitctrl.modell.att.WerteBereich;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsFahrzeugDichte;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttBemessungsVerkehrsStaerkeStunde;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttGeschwindigkeit;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttVerkehrsStaerkeStunde;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.onlinedaten.OdVerkehrsDatenKurzZeitMq;

public class VerkehrsDatenKurzZeitMqGenerator {

	public enum Messwert {

		QPkw, QLkw, QKfz, VPkw, VLkw, VKfz, QB, SKfz, KB;

	}

	private final Random datenquelle = new Random();
	private final Map<Messwert, Number> minimas = new HashMap<>();
	private final Map<Messwert, Number> maximas = new HashMap<>();

	public VerkehrsDatenKurzZeitMqGenerator() {
		minimas.put(Messwert.QPkw, 0);
		minimas.put(Messwert.QLkw, 0);
		minimas.put(Messwert.QKfz, 0);
		minimas.put(Messwert.VPkw, 0);
		minimas.put(Messwert.VLkw, 0);
		minimas.put(Messwert.VKfz, 0);
		minimas.put(Messwert.QB, 0);
		minimas.put(Messwert.SKfz, 0);
		minimas.put(Messwert.KB, 0);

		maximas.put(Messwert.QPkw, 15000);
		maximas.put(Messwert.QLkw, 15000);
		maximas.put(Messwert.QKfz, 15000);
		maximas.put(Messwert.VPkw, WerteBereich.getWerteBereich(AttGeschwindigkeit.class).getMaximum());
		maximas.put(Messwert.VLkw, WerteBereich.getWerteBereich(AttGeschwindigkeit.class).getMaximum());
		maximas.put(Messwert.VKfz, WerteBereich.getWerteBereich(AttGeschwindigkeit.class).getMaximum());
		maximas.put(Messwert.QB, WerteBereich.getWerteBereich(AttBemessungsVerkehrsStaerkeStunde.class).getMaximum());
		maximas.put(Messwert.SKfz, WerteBereich.getWerteBereich(AttGeschwindigkeit.class).getMaximum());
		maximas.put(Messwert.KB, WerteBereich.getWerteBereich(AttBemessungsFahrzeugDichte.class).getMaximum());
	}

	public Number getMaxWert(final Messwert name) {
		return maximas.get(name);
	}

	public Number getMinWert(final Messwert name) {
		return minimas.get(name);
	}

	public void setMaxWert(final Messwert name, final Number max) {
		maximas.put(name, max.intValue());
	}

	public void setMinWert(final Messwert name, final Number min) {
		minimas.put(name, min.intValue());
	}

	public OdVerkehrsDatenKurzZeitMq.Daten generiere() {
		final OdVerkehrsDatenKurzZeitMq.Daten datum = new OdVerkehrsDatenKurzZeitMq.Daten(null, null);
		int bandbreite;
		int qLkw, qKfz;

		bandbreite = getMaxWert(Messwert.QKfz).intValue() - getMinWert(Messwert.QKfz).intValue();
		qKfz = getMinWert(Messwert.QKfz).intValue() + (int) (datenquelle.nextDouble() * bandbreite);
		datum.getQKfz().setWert(new AttVerkehrsStaerkeStunde(qKfz));

		if (getMinWert(Messwert.QLkw).intValue() > getMaxWert(Messwert.QKfz).intValue()) {
			// Sonderfall, um Endlosschleife zu vermeiden, wenn Minimum(QLkw) >
			// Maximum(QKfz)
			qLkw = getMaxWert(Messwert.QKfz).intValue();
		} else {
			bandbreite = getMaxWert(Messwert.QLkw).intValue() - getMinWert(Messwert.QLkw).intValue();
			do {
				qLkw = getMinWert(Messwert.QLkw).intValue() + (int) (datenquelle.nextDouble() * bandbreite);
			} while (qLkw > qKfz);
		}
		datum.getQLkw().setWert(new AttVerkehrsStaerkeStunde(qLkw));

		bandbreite = getMaxWert(Messwert.VPkw).intValue() - getMinWert(Messwert.VPkw).intValue();
		datum.getVPkw().setWert(new AttGeschwindigkeit(
				(short) (getMinWert(Messwert.VPkw).intValue() + (int) (datenquelle.nextDouble() * bandbreite))));

		bandbreite = getMaxWert(Messwert.VLkw).intValue() - getMinWert(Messwert.VLkw).intValue();
		datum.getVLkw().setWert(new AttGeschwindigkeit(
				(short) (getMinWert(Messwert.VLkw).intValue() + (int) (datenquelle.nextDouble() * bandbreite))));

		bandbreite = getMaxWert(Messwert.SKfz).intValue() - getMinWert(Messwert.SKfz).intValue();
		datum.getSKfz().setWert(new AttGeschwindigkeit(
				(short) (getMinWert(Messwert.SKfz).intValue() + (int) (datenquelle.nextDouble() * bandbreite))));

		bandbreite = getMaxWert(Messwert.KB).intValue() - getMinWert(Messwert.KB).intValue();
		datum.getKB().setWert(new AttBemessungsFahrzeugDichte(
				(short) (getMinWert(Messwert.KB).intValue() + (int) (datenquelle.nextDouble() * bandbreite))));
		return datum;
	}

}
