/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
/* Copyright by BitCtrl Systems Leipzig */
/* BitCtrl Systems Leipzig */
/* Weisenfelser Str. 67 */
/* 04229 Leipzig */
/* Tel.: +49 341 49067 - 0 */
/* Fax.: +49 341 49067 - 15 */
/* mailto:info@bitctrl.de */
/* http://www.bitctrl.de */
/*---------------------------------------------------------------*/
package de.bsvrz.sys.funclib.bitctrl.modell.util.wzg;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import de.bsvrz.dav.daf.main.impl.InvalidArgumentException;
import de.bsvrz.sys.funclib.bitctrl.modell.DefaultObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.BitctrlAnzeige;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.De;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.Eak;

/**
 * Hilfsklasse, um an De zusätzliche Operationen ausführen zu können, die vom
 * Modell nicht vorgefertigt geliefert werden. Dies ist vorrangig das
 * Bereitstellen von Rückwärts-Referenzen.
 *
 * @author BitCtrl Systems GmbH, uhlmann
 *
 */
public final class DeUtils {

	/**
	 * Ein Cache für bereits abgefragte Eak.
	 */
	private static final Map<De, Eak> DE_EAK_MAP = new LinkedHashMap<>();

	/**
	 * Ein Cache für bereits abgefragte Anzeigen.
	 */
	private static final Map<DeWzg, BitctrlAnzeige> DE_WZG_ANZEIGE_MAP = new LinkedHashMap<>();

	private DeUtils() {
		// Konstruktor verstecken.
	}

	/**
	 * Liefert den Eak, in dessen De-Menge sich dieses De befindet.
	 *
	 * @param de die DE, dür die der EAK erfragt wird
	 *
	 * @return den Eak
	 * @throws InvalidArgumentException falls kein EAK gefunden wurde.
	 */
	public static Eak getEak(final De de) throws InvalidArgumentException {
		Eak eak = DE_EAK_MAP.get(de);
		if (eak == null) {
			final List<? extends SystemObjekt> eakObjekte = DefaultObjektFactory.getInstanz()
					.bestimmeModellobjekte(Eak.PID);
			for (final SystemObjekt objekt : eakObjekte) {
				final Eak curEak = (Eak) objekt;
				if (curEak.getDe().contains(de)) {
					DE_EAK_MAP.put(de, curEak);
					eak = curEak;
					break;
				}
			}
			if (eak == null) {
				throw new InvalidArgumentException("DE " + de.getName() + " ist keinem EAK zugeordnet");
			}
		}
		return eak;
	}

	/**
	 * Liefert die {@link BitctrlAnzeige}, in deren SchaltDeList sich die übergebene
	 * {@link DeWzg} befindet.
	 *
	 * @param deWzg die De
	 * @return die Anzeige
	 * @throws IllegalArgumentException Wenn die Anzeige nicht ermittelt werden
	 *                                  konnte
	 */
	public static BitctrlAnzeige getAnzeige(final DeWzg deWzg) throws IllegalArgumentException {
		BitctrlAnzeige anzeige = DE_WZG_ANZEIGE_MAP.get(deWzg);
		if (anzeige == null) {
			final List<? extends SystemObjekt> eakObjekte = DefaultObjektFactory.getInstanz()
					.bestimmeModellobjekte(BitctrlAnzeige.PID);
			for (final SystemObjekt objekt : eakObjekte) {
				final BitctrlAnzeige curAnzeige = (BitctrlAnzeige) objekt;
				if (curAnzeige.getKdAnzeigeEigenschaften().getDatum().getDeList().contains(deWzg)) {
					DE_WZG_ANZEIGE_MAP.put(deWzg, curAnzeige);
					anzeige = curAnzeige;
					break;
				}
			}
			if (anzeige == null) {
				throw new IllegalArgumentException("DE " + deWzg.getName() + " ist keiner BitctrlAnzeige zugeordnet");
			}
		}
		return anzeige;
	}
}
