/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2011 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
/* Copyright by BitCtrl Systems Leipzig */
/* BitCtrl Systems Leipzig */
/* Weisenfelser Str. 67 */
/* 04229 Leipzig */
/* Tel.: +49 341 49067 - 0 */
/* Fax.: +49 341 49067 - 15 */
/* mailto:info@bitctrl.de */
/* http://www.bitctrl.de */
/*---------------------------------------------------------------*/
/**
 *
 */
package de.bsvrz.sys.funclib.bitctrl.modell.util.wzg;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import de.bsvrz.sys.funclib.bitctrl.modell.DefaultObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik;
import de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.BitctrlAnzeige;
import de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.BitctrlWzgInhaltGrafik;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode;
import de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg;

/**
 * @author BitCtrl Systems GmbH, hoesel
 *
 */
public final class WzgInhaltGrafikUtil {

	/**
	 * Ein Cache für bereits abgefragte {@link WvzInhalt}.
	 */
	private static final Map<WzgInhaltGrafik, AnzeigeTyp> WZG_INHALT_GRAFIK_ANZEIGEN_TYP_MAP = new LinkedHashMap<>();

	private WzgInhaltGrafikUtil() {
		// Konstruktor verstecken
	}

	/**
	 * Die Methode ermittelt den zu einem GrafikInhalt gehörenden Anzeigetyp.
	 *
	 * @param inhaltGrafik die Grafik
	 * @return der Anzeigetyp
	 * @throws IllegalArgumentException falls der Anzeigetyp nicht ermittelt werden
	 *                                  konnte (i.d.R. ist das ein
	 *                                  Konfigurationsfehler)
	 */
	public static AnzeigeTyp getAnzeigeTyp(final WzgInhaltGrafik inhaltGrafik) throws IllegalArgumentException {
		AnzeigeTyp anzeigeTyp = WZG_INHALT_GRAFIK_ANZEIGEN_TYP_MAP.get(inhaltGrafik);
		if (anzeigeTyp == null) {
			final List<? extends SystemObjekt> anzeigeTypObjekte = DefaultObjektFactory.getInstanz()
					.bestimmeModellobjekte(AnzeigeTyp.PID);
			for (final SystemObjekt objekt : anzeigeTypObjekte) {
				final AnzeigeTyp curAnzeigeTyp = (AnzeigeTyp) objekt;
				for (final WvzInhalt inhalt : curAnzeigeTyp.getWvzInhalt()) {
					if (inhalt.getKdWvzInhalt().getDatum().getGrafikDarstellungen().contains(inhaltGrafik)) {
						WZG_INHALT_GRAFIK_ANZEIGEN_TYP_MAP.put(inhaltGrafik, curAnzeigeTyp);
						anzeigeTyp = curAnzeigeTyp;
						break;
					}
				}
			}
			if (anzeigeTyp == null) {
				throw new IllegalArgumentException(
						"WzgInhaltGrafik " + inhaltGrafik.getName() + " ist keinem AnzeigeTypen zugeordnet");
			}
		}
		return anzeigeTyp;
	}

	/**
	 * Die Methode ermittelt den zu einer {@link DeWzg} und vorgegebenem Stellcode
	 * gehörenden GrafikInhalt.
	 *
	 * @param deWzg        die DE der FG4
	 * @param stellCodeIst der vorgegebene Stellcode
	 * @return der GrafikInhalt
	 * @throws IllegalArgumentException wenn der GrafikInhalt nicht ermittelt werden
	 *                                  konnte (i.d.R. ist das ein
	 *                                  Konfigurationsfehler)
	 */
	public static BitctrlWzgInhaltGrafik getBitCtrlWzgInhaltGrafik(final DeWzg deWzg, final int stellCodeIst)
			throws IllegalArgumentException {
		BitctrlWzgInhaltGrafik inhalt = null;
		final BitctrlAnzeige anzeige = DeUtils.getAnzeige(deWzg);
		final AnzeigeTyp anzeigetyp = anzeige.getKdAnzeige().getDatum().getAnzeigeTyp();
		final WvzInhalt wvzInhalt = anzeigetyp.getWvzInhalt().iterator().next();
		for (final WzgInhaltGrafik wzgInhaltGrafik : wvzInhalt.getKdWvzInhalt().getDatum().getGrafikDarstellungen()) {
			if (wzgInhaltGrafik instanceof BitctrlWzgInhaltGrafik) {
				final BitctrlWzgInhaltGrafik bitctrlWzgInhaltGrafik = (BitctrlWzgInhaltGrafik) wzgInhaltGrafik;
				final AttTlsWzgWvzCode stellCode = bitctrlWzgInhaltGrafik.getKdInhaltUmsetzung().getDatum().getCode()
						.get(0);
				if ((stellCode != null) && (stellCode.intValue() == stellCodeIst)) {
					inhalt = bitctrlWzgInhaltGrafik;
					break;
				}
			}
		}
		if (inhalt == null) {
			throw new IllegalArgumentException("Für DE WZG " + deWzg.getName() + " und Stellcode " + stellCodeIst
					+ " konnte kein BitctrlWzgInhaltGrafik ermittelt werden");
		}
		return inhalt;
	}
}
