/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell;

import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;

/**
 * Gemeisame Schnittstelle für konfigurierende Datensätze.
 *
 * <p>
 * Konfigurierende Daten besitzen in der Regel den Aspekt
 * <code>asp.eigenschaften</code>. Der Zugriff auf dessen Daten wird durch
 * zusätzliche Methoden vereinfacht. Konfigurierende Daten mit anderen Aspekten
 * können mit den Methoden von {@link Datensatz} verarbeitet werden.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @param <T> der Typ des Konfigurationsdatums
 */
public interface KonfigurationsDatensatz<T extends KonfigurationsDatum> extends Datensatz<T> {

	/**
	 * Gibt den konfigurierenden Datensatz mit dem Standardaspekt
	 * <code>asp.eigenschaften</code> zurück.
	 *
	 * @return das Datum unter dem Standardaspekt.
	 */
	T getDatum();

	/**
	 * Schreibt das Datum als konfigurierenden Datensatz mit dem Standardaspekt
	 * <code>asp.eigenschaften</code>.
	 *
	 * @param datum das zu schreibende Datum.
	 * @throws ConfigurationChangeException das Schreiben der Daten in die
	 *                                      Konfiguration des Datenverteilers ist
	 *                                      fehlgeschlagen
	 */
	void setDatum(final T datum) throws ConfigurationChangeException;

	/**
	 * Schreibt das Datum als konfigurierenden Datensatz.
	 *
	 * @param asp   der Aspekt unter dem das Datum geschrieben weden soll.
	 * @param datum das zu schreibende Datum.
	 * @throws ConfigurationChangeException das Schreiben der Daten in die
	 *                                      Konfiguration des Datenverteilers ist
	 *                                      fehlgeschlagen
	 */
	void setDatum(final Aspekt asp, final T datum) throws ConfigurationChangeException;

}
