/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell;

import java.util.Collection;
import java.util.EventObject;

/**
 * Kapselt die Änderung an einer online änderbaren Menge.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @see AenderbareMenge
 */
public class MengenEvent extends EventObject {

	private final Collection<? extends SystemObjekt> hinzugefuegt;
	private final Collection<? extends SystemObjekt> entfernt;

	/**
	 * Erzeugt das Ereignis
	 *
	 * @param source       die Quelle des Ereignisses; die Menge.
	 * @param hinzugefuegt die hinzugefügten Objekt.
	 * @param entfernt     die entfernten Objekte.
	 */
	public MengenEvent(final AenderbareMenge<? extends SystemObjekt> source,
			final Collection<? extends SystemObjekt> hinzugefuegt, final Collection<? extends SystemObjekt> entfernt) {
		super(source);

		this.hinzugefuegt = hinzugefuegt;
		this.entfernt = entfernt;
	}

	/**
	 * Gibt die Menge zurück, die sich bei diesem Ereignis geändert hat.
	 *
	 * @return die geänderte Menge.
	 */
	public AenderbareMenge<SystemObjekt> getMenge() {
		return (AenderbareMenge<SystemObjekt>) getSource();
	}

	/**
	 * Gibt die Objekte zurück, die der Menge bei diesem Ereignis hinzugefügt
	 * wurden.
	 *
	 * @return die der Menge hinzugefügten Objekte.
	 */
	public Collection<? extends SystemObjekt> getHinzugefuegt() {
		return hinzugefuegt;
	}

	/**
	 * Gibt die Objekte zurück, die aus der Menge bei diesem Ereignis entfernt
	 * wurden.
	 *
	 * @return die aus der Menge entfernte Objekte.
	 */
	public Collection<? extends SystemObjekt> getEntfernt() {
		return entfernt;
	}

	private static final long serialVersionUID = 1L;

}
