/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.AbstractSystemObjekt;

/**
 * Mock-Objekt als einfacher Wrapper für Systemobjekte, die im Modell nicht
 * explizit modelliert sind.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class MockSystemObjekt extends AbstractSystemObjekt {

	/**
	 * Initialisiert das Mock-Objekt mit dem zu wrappenden {@link SystemObject}.
	 *
	 * @param objekt  das gewrappte Objekt.
	 * @param factory die Factory, die das {@link SystemObjekt} verwaltet.
	 */
	public MockSystemObjekt(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
	}

	@Override
	protected String doGetTypPid() {
		final SystemObject systemObject = getSystemObject();
		if (systemObject.equals(systemObject.getDataModel().getTypeTypeObject())) {
			throw new IllegalStateException("Typ: " + systemObject
					+ " hat keinen Supertyp. Vermutlich ist das Datenmodell im Klassenpfad nicht verfügbar!");
		}
		return getObjektFactory().getModellobjekt(systemObject.getType()).getPid();
	}

}
