/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell;

import java.util.EventObject;

import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatensatz.Status;

/**
 * Das Ereignis tritt ein, wenn sich der Status der Sendesteuerung ge&auml;ndert
 * hat.
 *
 * @author BitCtrl Systems GmbH, St. Gieseler
 */
public class SendeSteuerungEvent extends EventObject {

	/** Die Versions-ID der Serialialisierung. */
	private static final long serialVersionUID = 1L;

	/** Der betroffene Aspekt. */
	private final Aspekt aspekt;

	/**
	 * Die Simulationsvariante des Datensatzes. Default = -1.
	 *
	 * @see DataDescription#NO_SIMULATION_VARIANT_SET
	 */
	private short simulationsVariante = DataDescription.NO_SIMULATION_VARIANT_SET;

	/** Der Status der Sendesteuerung. */
	private final Status status;

	/**
	 * Der Konstruktor des Ereignisses.
	 *
	 * @param datensatz           der Datensatz, der sich ge&auml;ndert hat.
	 * @param aspekt              der betroffene Aspekt.
	 * @param simulationsVariante die Simulationsvariante des Datensatzes.
	 * @param status              der Status der Sendesteuerung.
	 */
	public SendeSteuerungEvent(final Datensatz<?> datensatz, final Aspekt aspekt, final short simulationsVariante,
			final Status status) {
		super(datensatz);
		this.aspekt = aspekt;
		this.simulationsVariante = simulationsVariante;
		this.status = status;
	}

	/**
	 * Der Konstruktor des Ereignisses.
	 *
	 * @param datensatz der Datensatz, der sich ge&auml;ndert hat.
	 * @param aspekt    der betroffene Aspekt.
	 * @param status    der Status der Sendesteuerung.
	 */
	public SendeSteuerungEvent(final Datensatz<?> datensatz, final Aspekt aspekt, final Status status) {
		this(datensatz, aspekt, DataDescription.NO_SIMULATION_VARIANT_SET, status);
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code aspekt} wieder.
	 *
	 * @return {@code aspekt}.
	 */
	public Aspekt getAspekt() {
		return aspekt;
	}

	/**
	 * Gibt den ge&auml;nderten Datensatz zur&uuml;ck.
	 *
	 * @return der ge&auml;nderte Datensatz.
	 */
	public Datensatz<?> getDatensatz() {
		return (Datensatz<?>) source;
	}

	/**
	 * Gibt das Systemobjekt zur&uuml;ck, dessen Datensatz sich ge&auml;ndert hat.
	 *
	 * @return das Systemobjekt.
	 */
	public SystemObjekt getObjekt() {
		return getDatensatz().getSystemObjekt();
	}

	/**
	 * Gibt den Status der Sendesteuerungzur&uuml;ck.
	 *
	 * @return Status
	 */
	public Status getStatus() {
		return status;
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "[source=" + source + ", status=" + status + "]";
	}

	/**
	 * Die Simulationsvariante des Datensatzes.
	 *
	 * @return the simulationsVariante
	 */
	public final short getSimulationsVariante() {
		return simulationsVariante;
	}

}
