/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.att;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;

/**
 * Kapselt die Daten eines zusammengesetzten Datums.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public interface Attributliste {

	/**
	 * Schreibt die Daten des Java-Objekts in die übergebenen Attributliste.
	 *
	 * <p>
	 * <em>Hinweis:</em> Diese Methode gehört nicht zu public API.
	 *
	 * @param daten   die zum Objekt korrespondierende Attributliste.
	 * @param factory die Objektfabrik, die zur Übersetzung zwischen Datenverteiler
	 *                und Modell verwendet werden soll.
	 */
	void bean2Atl(Data daten, ObjektFactory factory);

	/**
	 * Liest die Daten aus der übergebenen Attributliste und übernimmt sie in das
	 * Java-Objekt.
	 *
	 * <p>
	 * <em>Hinweis:</em> Diese Methode gehört nicht zu public API.
	 *
	 * @param daten   die zum Objekt korrespondierende Attributliste.
	 * @param factory die Objektfabrik, die zur Übersetzung zwischen Datenverteiler
	 *                und Modell verwendet werden soll.
	 */
	void atl2Bean(Data daten, ObjektFactory factory);

	/**
	 * Macht eine tiefe Kopie der Attributliste.
	 *
	 * @return der Klon.
	 */
	Attributliste clone();

}
