/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.impl;

import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.Datensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.Datum;

/**
 * Implementietr die allgemeinen Funktionen der Schnittstelle.
 *
 * @author BitCtrl Systems GmbH, schumann
 */
public abstract class AbstractDatum implements Datum {

	private final Datensatz datensatz;
	private Aspekt aspekt;

	/**
	 * Initialisiert das Datum.
	 *
	 * @param datensatz der Datensatz zu dem das Datum gehört.
	 * @param aspekt    der Aspekt für das Datum.
	 */
	protected AbstractDatum(final Datensatz datensatz, final Aspekt aspekt) {
		this.datensatz = datensatz;
		this.aspekt = aspekt;
	}

	@Override
	public Datensatz dGetDatensatz() {
		return datensatz;
	}

	@Override
	public Aspekt dGetAspekt() {
		return aspekt;
	}

	/**
	 * Setzt den Aspekt des Datums.
	 *
	 * <p>
	 * <em>Hinweis:</em> Diese Methode ist nicht Teil der public-API.
	 *
	 * @param aspekt der zu setzende Aspekt.
	 */
	public void dSetAspekt(@SuppressWarnings("hiding") final Aspekt aspekt) {
		this.aspekt = aspekt;
	}

	@Override
	public abstract Datum clone();

}
