/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.impl;

import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.Datensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.OnlineDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.att.Zeitstempel;

/**
 * Implementiert die Gemeinsamkeiten der Schnittstelle.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public abstract class AbstractOnlineDatum extends AbstractDatum implements OnlineDatum {

	private Zeitstempel zeitstempel;
	private Status status = Status.UNDEFINIERT;

	/**
	 * Initialisiert das Onlinedatum.
	 *
	 * @param datensatz der Datensatz zu dem das Datum gehört.
	 * @param aspekt    der Aspekt für das Datum.
	 */
	public AbstractOnlineDatum(final Datensatz datensatz, final Aspekt aspekt) {
		super(datensatz, aspekt);
	}

	@Override
	public Zeitstempel dGetZeitstempel() {
		return zeitstempel;
	}

	@Override
	public void dSetZeitstempel(final Zeitstempel z) {
		zeitstempel = z;
	}

	@Override
	public final boolean dContainsDaten() {
		return dGetDatenStatus() == OnlineDatum.Status.DATEN;
	}

	@Override
	public Status dGetDatenStatus() {
		return status;
	}

	/**
	 * Setzt den aktuellen Status des Datensatzes.
	 *
	 * @param datenStatus der neue Status
	 */
	public void dSetDatenStatus(final Status datenStatus) {
		status = datenStatus;
	}

	@Override
	public abstract OnlineDatum clone();

}
