/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell;

import java.util.Collection;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.AttributeGroup;

/**
 * Schnittstelle f&uuml;r den Inhalt einer Attributgruppen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @param <T> Der Typ des Datums den der Datensatz sichert.
 */
public interface Datensatz<T extends Datum> extends KonfigurationsObjekt {

	/**
	 * Erzeugt ein leeres oder mit Standardwerten ausgef&uuml;lltes Datum des
	 * Datensatzes. Dieses Datum kann nach dem Ausf&uuml;llen an den Datenverteiler
	 * versandt werden.
	 *
	 * @return das Datum.
	 */
	T createDatum();

	/**
	 * Gibt das Systemobjekt zur&uuml;ck, zu dem der Datensatz geh&ouml;rt.
	 *
	 * @return das Objekt, zu dem der Datensatz geh&ouml;rt.
	 */
	SystemObjekt getSystemObjekt();

	/**
	 * Gibt die verf&uuml;gbaren Aspekte zur&uuml;ck.
	 *
	 * @return die Menge der verf&uuml;gbaren Aspekte.
	 */
	Collection<? extends Aspekt> getAspekte();

	/**
	 * Gibt die aktuellen Daten des Datensatzes zurück. Es erfolgt eine implizite
	 * Empfängeranmeldung für 1 Stunde.
	 *
	 * @param asp der betroffene Aspekt.
	 * @return ein Datum, welches die Daten des Datensatzes kapselt.
	 */
	T getDatum(Aspekt asp);

	/**
	 * Konvertiert ein Modelldatum in ein Datenverteilerdatum.
	 *
	 * <p>
	 * <em>Hinweis:</em> Diese Methode gehört nicht zur public API.
	 *
	 * @param datum das Datum, welches konvertiert werden soll.
	 * @return das Datenverteilerdatum.
	 */
	Data konvertiere(T datum);

	/**
	 * Konvertiert ein Datenverteilerdatum ein Modelldatum.
	 *
	 * <p>
	 * <em>Hinweis:</em> Diese Methode gehört nicht zur public API.
	 *
	 * @param daten das Datum, welches konvertiert werden soll.
	 * @return das Modelldatum.
	 */
	T konvertiere(ResultData daten);

	@Override
	AttributeGroup getSystemObject();

}
