/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell;

import java.util.EventObject;

import de.bsvrz.dav.daf.main.DataDescription;

/**
 * Das Ereignis tritt ein, wenn ein Datensatz ge&auml;ndert wurde.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class DatensatzUpdateEvent extends EventObject {

	/** Die Versions-ID der Serialialisierung. */
	private static final long serialVersionUID = 1L;

	/** Der betroffene Aspekt. */
	private final Aspekt aspekt;

	/** Das Datum des Datensatzes zum Zeitpunkt des Events. */
	private final OnlineDatum datum;

	/**
	 * Die Simulationsvariante des Datensatzes. Default = -1.
	 *
	 * @see DataDescription#NO_SIMULATION_VARIANT_SET
	 */
	private short simulationsVariante = DataDescription.NO_SIMULATION_VARIANT_SET;

	/**
	 * Der Konstruktor des Ereignisses.
	 *
	 * @param datensatz           der Datensatz, der sich ge&auml;ndert hat.
	 * @param aspekt              der betroffene Aspekt.
	 * @param simulationsVariante die Simulationsvariante des Datensatzes.
	 * @param datum               die Daten des Datensatzes zum Zeitpunkt des
	 *                            Events.
	 */
	public DatensatzUpdateEvent(final Datensatz<?> datensatz, final Aspekt aspekt, final short simulationsVariante,
			final OnlineDatum datum) {
		super(datensatz);
		this.aspekt = aspekt;
		this.datum = datum;
		this.simulationsVariante = simulationsVariante;
	}

	/**
	 * Der Konstruktor des Ereignisses.
	 *
	 * @param datensatz der Datensatz, der sich ge&auml;ndert hat.
	 * @param aspekt    der betroffene Aspekt.
	 * @param datum     die Daten des Datensatzes zum Zeitpunkt des Events.
	 */
	public DatensatzUpdateEvent(final Datensatz<?> datensatz, final Aspekt aspekt, final OnlineDatum datum) {
		this(datensatz, aspekt, DataDescription.NO_SIMULATION_VARIANT_SET, datum);
	}

	/**
	 * Gibt den Wert der Eigenschaft {@code aspekt} wieder.
	 *
	 * @return {@code aspekt}.
	 */
	public Aspekt getAspekt() {
		return aspekt;
	}

	/**
	 * Gibt den ge&auml;nderten Datensatz zur&uuml;ck.
	 *
	 * @return der ge&auml;nderte Datensatz.
	 */
	public Datensatz<?> getDatensatz() {
		return (Datensatz<?>) source;
	}

	/**
	 * Gibt das zum Zeitpunktz des Events g&uuml;ltige Datum des ge&auml;nderten
	 * Datensatzes zur&uuml;ck.
	 *
	 * @return das Datum.
	 */
	public OnlineDatum getDatum() {
		return datum;
	}

	/**
	 * Gibt das Systemobjekt zur&uuml;ck, dessen Datensatz sich ge&auml;ndert hat.
	 *
	 * @return das Systemobjekt.
	 */
	public SystemObjekt getObjekt() {
		return getDatensatz().getSystemObjekt();
	}

	@Override
	public String toString() {
		return getClass().getSimpleName() + "[source=" + source + ", datum=" + datum + "]";
	}

	/**
	 * Die Simulationsvariante des Datensatzes.
	 *
	 * @return the simulationsVariante
	 */
	public final short getSimulationsVariante() {
		return simulationsVariante;
	}

}
