/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell;

/**
 * Ausnahme die von einem Datensender geworfen wird, wenn Daten gesendet werden
 * konnten.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class DatensendeException extends Exception {

	/** Versions-ID der Serialisierung. */
	private static final long serialVersionUID = 1L;

	/**
	 * Konstruktor.
	 */
	public DatensendeException() {
		// nix
	}

	/**
	 * Konstruktor.
	 *
	 * @param datensatz der betroffene Datensatz
	 *
	 * @param message   eine Fehlernachricht.
	 */
	public DatensendeException(final Datensatz<?> datensatz, final String message) {
		super(message + " [datensatz=" + datensatz + "]");
	}

	/**
	 * Konstruktor.
	 *
	 * @param message eine Fehlernachricht.
	 */
	public DatensendeException(final String message) {
		super(message);
	}

	/**
	 * Konstruktor.
	 *
	 * @param message eine Fehlernachricht.
	 * @param cause   ein Grund.
	 */
	public DatensendeException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * Konstruktor.
	 *
	 * @param cause ein Grund.
	 */
	public DatensendeException(final Throwable cause) {
		super(cause);
	}

}
