/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.att;

import com.bitctrl.Constants;

/**
 * Kapselt ein relatives Zeitstempelattribut eines Datensatzes.
 *
 * @author BitCtrl Systems GmbH, Falko Schuman
 */
public class RelativerZeitstempel extends Zeitstempel {

	/**
	 * Initialisiert den Zeitstempel mit der relativen Zeit 0 Sekunden.
	 */
	public RelativerZeitstempel() {
		this(0);
	}

	/**
	 * Initialsiert den relativen Zeitstempel.
	 *
	 * @param time die relative Zeit.
	 */
	public RelativerZeitstempel(final long time) {
		super(time);
	}

	@Override
	public boolean equals(final Object obj) {
		if (obj == this) {
			return true;
		} else if (obj instanceof RelativerZeitstempel) {
			return compareTo((RelativerZeitstempel) obj) == 0;
		}
		return false;
	}

	@Override
	public int hashCode() {
		return Long.valueOf(getTime()).hashCode();
	}

	@Override
	public String toString() {
		final StringBuilder result = new StringBuilder();
		long remainder = getTime();

		remainder = remainder(result, remainder, Constants.MILLIS_PER_DAY, "Tag", "Tage");
		remainder = remainder(result, remainder, Constants.MILLIS_PER_HOUR, "Stunde", "Stunden");
		remainder = remainder(result, remainder, Constants.MILLIS_PER_MINUTE, "Minute", "Minuten");
		remainder = remainder(result, remainder, Constants.MILLIS_PER_SECOND, "Sekunde", "Sekunden");
		remainder(result, remainder, 1, "Millisekunde", "Millisekunden");

		if (result.length() == 0) {
			result.append("0 Millisekunden");
		}

		return result.toString();
	}

	private long remainder(final StringBuilder result, final long remainder, final long factor,
			final String measureSingular, final String measurePlural) {
		final long part = remainder / factor;

		// Nur Werte ungleich 0 werden aufgenommen
		if (part != 0) {
			// Wenn dies nicht der erste Wert ist, dann als erstes Leerzeichen
			if (result.length() > 0) {
				result.append(' ');
			}

			result.append(part);
			result.append(" ");
			if ((part == 1) || (part == -1)) {
				result.append(measureSingular);
			} else {
				result.append(measurePlural);
			}
		}
		return remainder - (part * factor);
	}

}
