/*
 * Allgemeine Funktionen BitCtrl Modell
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.modell.impl;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.sys.funclib.bitctrl.modell.Aspekt;
import de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsDatensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsDatum;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;

/**
 * Implementiert gemeinsame Methoden der Schnittstelle.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 * @param <T> der Typ des Datensatzes
 */
public abstract class AbstractKonfigurationsDatensatz<T extends KonfigurationsDatum> extends AbstractDatensatz<T>
		implements KonfigurationsDatensatz<T> {

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 *
	 * @param systemObjekt  das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public AbstractKonfigurationsDatensatz(final SystemObjekt systemObjekt, final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	@Override
	public T getDatum() {
		final T datum = createDatum();
		final Data data = getSystemObjekt().getSystemObject().getConfigurationData(getSystemObject());
		// TODO Wie wird keine "Keine Rechte" erkannt???
		if (data != null) {
			datum.atl2Bean(data, getObjektFactory());
			return datum;
		}

		return null;
	}

	@Override
	public void setDatum(final T datum) throws ConfigurationChangeException {
		final Data data = konvertiere(datum);
		getSystemObjekt().getSystemObject().setConfigurationData(getSystemObject(), data);
	}

	@Override
	public T getDatum(final Aspekt asp) {
		final T datum = createDatum();
		final Data data = getSystemObjekt().getSystemObject().getConfigurationData(getSystemObject(), getAspect(asp));
		// TODO Wie wird keine "Keine Rechte" erkannt???
		if (data != null) {
			datum.atl2Bean(data, getObjektFactory());
			if (datum instanceof AbstractDatum) {
				((AbstractDatum) datum).dSetAspekt(asp);
			}
			return datum;
		}

		return null;
	}

	@Override
	public void setDatum(final Aspekt asp, final T datum) throws ConfigurationChangeException {
		final Data data = konvertiere(datum);
		getSystemObjekt().getSystemObject().setConfigurationData(getSystemObject(), getAspect(asp), data);
	}

	@Override
	public Data konvertiere(final T datum) {
		final Data daten = createSendeCache();
		datum.bean2Atl(daten, getObjektFactory());
		return daten;
	}

	@Override
	public T konvertiere(final ResultData result) {
		check(result);

		final T datum = createDatum();
		if (result.hasData()) {
			final Data daten = result.getData();
			datum.atl2Bean(daten, getObjektFactory());
			return datum;
		}

		return null;
	}

}
