/*
 * Allgemeine Funktionen mit und ohne Datenverteilerbezug
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.bitctrl.daf;

import java.util.EventListener;

import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Listener zur Anmeldung am {@link SendRegistrationStore}, um &uuml;ber
 * Sendefreigaben (dataRequest) informiert zu werden.
 *
 * @author BitCtrl Systems GmbH, Gieseler
 */
public interface SendRegistrationStoreDataRequestListener extends EventListener {

	/**
	 * Wird vom {@link SendRegistrationStore} bei jedem
	 * {@link ClientSenderInterface#dataRequest(SystemObject, DataDescription, byte)}
	 * -Callback aufgerufen.
	 *
	 * @param obj   das Systemobjekt zu dem die Daten gehören
	 * @param desc  die Datenbeschreibung
	 * @param state der Status der Sendesteuerung
	 */
	void registrationStoreDataRequest(final SystemObject obj, final DataDescription desc, final byte state);
}
