/*
 * Allgemeine Funktionen mit und ohne Datenverteilerbezug
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.daf;

/**
 * Schnittstelle für eine Klasse zur Bestimmung der ID für eine Betriebsmeldung.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public interface BetriebsmeldungIdKonverter {

	/**
	 * bestimt die ID für eine Betriebsmeldung mit den übergebenen Daten.
	 *
	 * @param daten     die Daten zur Definition der Betriebsmeldung
	 * @param nachricht die zu versendende Nachricht
	 * @param arguments die Argumente der Nachricht
	 *
	 * @return die ID
	 */
	String konvertiere(BetriebsmeldungDaten daten, final LogNachricht nachricht, final Object... arguments);
}
