/*
 * Allgemeine Funktionen mit und ohne Datenverteilerbezug
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.daf;

/**
 * Fasst allgemeine Konstanten f&uuml;r die Arbeit mit dem Datenkatalog
 * zusammen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class DaVKonstanten {
	
	private DaVKonstanten() {
		// Konstruktor verstecken
	}

	/** Aspekt f&uuml;r Soll-Angaben eines Parameter. */
	public static final String ASP_PARAMETER_SOLL = "asp.parameterSoll";

	/** Aspekt f&uuml;r das Einstellen eines Parameter. */
	public static final String ASP_PARAMETER_VORGABE = "asp.parameterVorgabe";

	/** Aspekt f&uuml;r den Ist-Zustand eines Parameters. */
	public static final String ASP_PARAMETER_IST = "asp.parameterIst";

	/** Aspekt f&uuml;r den Standardwert eines Parameters. */
	public static final String ASP_PARAMETER_DEFAULT = "asp.parameterDefault";

	/** Standardaspekt f&uuml;r Konfigurationsdaten. */
	public static final String ASP_EIGENSCHAFTEN = "asp.eigenschaften";

	/** Der Typ Typ. */
	public static final String TYP_TYP = "typ.typ";

	/** Der Typ Attributgruppe. */
	public static final String TYP_ATTRIBUTGRUPPE = "typ.attributgruppe";

	/** Der Typ Aspekt. */
	public static final String TYP_ASPEKT = "typ.aspekt";

}
