/*
 * Allgemeine Funktionen mit und ohne Datenverteilerbezug
 * Copyright (C) 2007-2021 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.interpreter.logik;

import java.util.Objects;

/**
 * Wertobjekt für einen booleschen Wert.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public final class LogischerWert {

	public static final LogischerWert WAHR = new LogischerWert(true);

	public static final LogischerWert FALSCH = new LogischerWert(false);

	public static LogischerWert of(final boolean wert) {
		return wert ? WAHR : FALSCH;
	}

	private final boolean wert;

	private LogischerWert(boolean wert) {
		this.wert = wert;
	}

	public boolean get() {
		return wert;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o)
			return true;
		if ((o == null) || (getClass() != o.getClass()))
			return false;
		final LogischerWert that = (LogischerWert) o;
		return wert == that.wert;
	}

	@Override
	public int hashCode() {
		return Objects.hash(wert);
	}

	@Override
	public String toString() {
		return wert ? "wahr" : "falsch";
	}

}
