/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.bundesland;

import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.inovat.lib.konstanten.Konstanten;
import de.inovat.buv.projektlib.dav.DavDatenVew;
import de.inovat.buv.projektlib.konstanten.KonstantenGUIResource;
import de.inovat.buv.projektlib.konstanten.Zustaende;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BundeslandVew {
    private static final String ORDNER_RESOURCE = "ProjektResource";
    private static BundeslandVew _instanzBundeslandVew = new BundeslandVew();
    private String _fehlerMeldungFuerOrdner = "";
    private boolean _bundeslandGeladen = false;
    private Zustaende.BundesLaender _bundesland;
    private String _ordnerBundeslandResource;

    private BundeslandVew() {
        this.initialisiereBundesland();
        this.initialisiereOrdnerBundeslandResource();
    }

    public String ermittleDateiImOrdnerBundeslandResource(String datei) {
        return String.valueOf(this.getOrdnerBundeslandResource()) + Konstanten.FILESEPARATOR + datei;
    }

    public Image ermittleLogoBundesland() {
        if (KonstantenGUIResource.ICON_LOGO_BUNDESLAND_AUS_PARAMETER != null) {
            return KonstantenGUIResource.ICON_LOGO_BUNDESLAND_AUS_PARAMETER;
        }
        return KonstantenGUIResource.MAP_ICON_LOGO_BUNDESLAND.get(this._bundesland.getAbkuerzung());
    }

    public Zustaende.BundesLaender getBundesland() {
        return this._bundesland;
    }

    public static BundeslandVew getInstanz() {
        return _instanzBundeslandVew;
    }

    public String getOrdnerBundeslandResource() {
        if (!this._fehlerMeldungFuerOrdner.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openError((Shell)shell, (String)"Fehler", (String)BundeslandVew.this._fehlerMeldungFuerOrdner);
                }
            });
        }
        return this._ordnerBundeslandResource;
    }

    private void initialisiereBundesland() {
        String param = DavDatenVew.getInstanz().getAufrufParameterAlsString("-bundesland");
        if (param != null) {
            this._bundesland = Zustaende.BundesLaender.ermittleBundesland(param);
        }
        if (this._bundesland == null || this._bundesland == Zustaende.BundesLaender.UNBEKANNT) {
            this._bundesland = Zustaende.BundesLaender.UNBEKANNT;
            Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)String.format("%s%s%s", "Das Bundesland ist im Kommandozeilenparameter <", "-bundesland", "> nicht definiert!")));
        }
        this._bundeslandGeladen = true;
        System.out.println("Bundesland: " + this._bundesland.getLand());
    }

    private void initialisiereOrdnerBundeslandResource() {
        String ordnerPrjRoot;
        String resOrd = ORDNER_RESOURCE + Konstanten.FILESEPARATOR + this._bundesland.getAbkuerzung();
        String par = "-resourceOrdner";
        String ordnerPar = "";
        try {
            ordnerPrjRoot = Platform.getInstallLocation().getURL().getPath();
        }
        catch (Exception e) {
            ordnerPrjRoot = "";
        }
        ordnerPrjRoot = String.format("%s%s", ordnerPrjRoot, resOrd);
        if (new File(ordnerPrjRoot).exists()) {
            this._ordnerBundeslandResource = ordnerPrjRoot;
        } else {
            String ord = DavDatenVew.getInstanz().getAufrufParameterAlsString(par);
            if (ord != null && new File(ordnerPar = String.format("%s%s%s", ord, Konstanten.FILESEPARATOR, resOrd)).exists()) {
                this._ordnerBundeslandResource = ordnerPar;
            }
        }
        if (this._ordnerBundeslandResource == null) {
            this._ordnerBundeslandResource = "";
            this._fehlerMeldungFuerOrdner = String.format("%s%s%s%s%s%s%s", "Der ProjektResource-Ordner f\u00fcr das Projekt wurde nicht gefunden!", Konstanten.NEWLINE, Konstanten.NEWLINE, "Er wurde zuerst in <", ordnerPrjRoot, "> gesucht.", Konstanten.NEWLINE);
            this._fehlerMeldungFuerOrdner = ordnerPar.isEmpty() ? String.format("%s%s%s%s", this._fehlerMeldungFuerOrdner, "Danach w\u00fcrde der \u00fcber den Aufrufparameter <", par, "> angegebene Ordner gepr\u00fcft.") : String.format("%s%s%s%s%s%s", this._fehlerMeldungFuerOrdner, "Danach wurde der \u00fcber den Aufrufparameter <", par, "> angegebene Ordner <", ordnerPar, "> gepr\u00fcft.");
            Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)this._fehlerMeldungFuerOrdner));
        }
        System.out.println("BundeslandResource-Ordner: " + this._ordnerBundeslandResource);
    }

    public boolean isBundeslandGeladen() {
        return this._bundeslandGeladen;
    }
}

