/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.dav;

import de.bsvrz.buv.rw.basislib.Rahmenwerk;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsEvent;
import de.bsvrz.buv.rw.basislib.dav.DavVerbindungsListener;
import de.bsvrz.dav.daf.main.archive.ArchiveAvailabilityListener;
import de.bsvrz.dav.daf.main.archive.ArchiveRequestManager;
import de.inovat.buv.projektlib.dav.IDavArchiv;
import de.inovat.buv.projektlib.rwservice.RWService;
import java.util.HashSet;
import java.util.Set;

public class DavArchivVew
implements ArchiveAvailabilityListener,
DavVerbindungsListener {
    private static DavArchivVew _instanz = new DavArchivVew();
    private final Set<IDavArchiv> _mengeArchivListener = new HashSet<IDavArchiv>();
    private ArchiveRequestManager _archiv;
    private Rahmenwerk _rw = RWService.getService().getRw();

    private DavArchivVew() {
        if (this._rw.isOnline()) {
            this._archiv = this._rw.getDavVerbindung().getArchive();
            this._archiv.addArchiveAvailabilityListener((ArchiveAvailabilityListener)this);
        }
        this._rw.addDavVerbindungsListener((DavVerbindungsListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArchivListener(IDavArchiv klasse) {
        Set<IDavArchiv> set = this._mengeArchivListener;
        synchronized (set) {
            this._mengeArchivListener.add(klasse);
        }
    }

    public void archiveAvailabilityChanged(ArchiveRequestManager archiv) {
        this.benachrichtigeArchivListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void benachrichtigeArchivListener() {
        IDavArchiv[] ar;
        Set<IDavArchiv> set = this._mengeArchivListener;
        synchronized (set) {
            ar = this._mengeArchivListener.toArray(new IDavArchiv[this._mengeArchivListener.size()]);
        }
        IDavArchiv[] iDavArchivArray = ar;
        int n = ar.length;
        int n2 = 0;
        while (n2 < n) {
            IDavArchiv klasse = iDavArchivArray[n2];
            klasse.archivStatusGeaendert(this.istArchivVerfuegbar());
            ++n2;
        }
    }

    public static DavArchivVew getInstanz() {
        return _instanz;
    }

    public boolean istArchivVerfuegbar() {
        if (this._archiv != null) {
            return this._archiv.isArchiveAvailable();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArchivListener(IDavArchiv klasse) {
        Set<IDavArchiv> set = this._mengeArchivListener;
        synchronized (set) {
            this._mengeArchivListener.remove(klasse);
        }
    }

    public void verbindungGetrennt(DavVerbindungsEvent event) {
        if (this._archiv != null) {
            this._archiv.removeArchiveAvailabilityListener((ArchiveAvailabilityListener)this);
            this._archiv = null;
        }
        this.benachrichtigeArchivListener();
    }

    public boolean verbindungHalten(DavVerbindungsEvent event) {
        return false;
    }

    public void verbindungHergestellt(DavVerbindungsEvent event) {
        if (this._rw.isOnline()) {
            this._archiv = this._rw.getDavVerbindung().getArchive();
            this._archiv.addArchiveAvailabilityListener((ArchiveAvailabilityListener)this);
        }
        this.benachrichtigeArchivListener();
    }
}

