/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.konstanten;

import de.inovat.buv.projektlib.dav.DavDatenVew;
import java.util.ArrayList;
import java.util.List;

public class Zustaende {
    private static final String PROJEKT_NAME_STANDARD = "inovatProjekt";
    public static final String PROJEKT_NAME;

    static {
        String param = DavDatenVew.getInstanz().getAufrufParameterAlsString("-projektName");
        String name = param != null ? param.replaceAll("[^a-zA-Z0-9-_]", "") : PROJEKT_NAME_STANDARD;
        PROJEKT_NAME = name;
    }

    public static enum BundesLaender {
        BADEN_WUERTTENBERG("Baden-W\u00fcrttemberg", "BW"),
        BAYERN("BAYERN", "BY"),
        BERLIN("BERLIN", "BE"),
        BRANDERBURG("Brandenburg", "BB"),
        BREMEN("Bremen", "HB"),
        HAMBURG("Hamburg", "HH"),
        HESSEN("Hessen", "HE"),
        MECKLENBURG_VORPOMMERN("Mecklenburg-Vorpommern", "MV"),
        NIEDERSACHSEN("Niedersachsen", "NI"),
        NORDRHEIN_WESTFALEN("Nordrhein-Westfalen", "NW"),
        RHEINLAND_PFALZ("Rheinland-Pfalz", "RP"),
        SAARLAND("SAARLAND", "SL"),
        SACHSEN("Sachsen", "SN"),
        SACHSEN_ANHALT("Sachsen-Anhalt", "ST"),
        SCHLESWIG_HOLSTEIN("Schleswig-Holstein", "SH"),
        THUERINGEN("Th\u00fcringen", "TH"),
        UNBEKANNT("unbekannt", "AA");

        private final String abkuerzung;
        private final String land;

        private BundesLaender(String land, String abkuerzung) {
            this.land = land;
            this.abkuerzung = abkuerzung;
        }

        public static List<String> ermittleBundesLaender() {
            ArrayList<String> liste = new ArrayList<String>();
            BundesLaender[] bundesLaenderArray = BundesLaender.values();
            int n = bundesLaenderArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundesLaender bl = bundesLaenderArray[n2];
                liste.add(bl.land);
                ++n2;
            }
            return liste;
        }

        public static BundesLaender ermittleBundesland(String bl) {
            BundesLaender[] bundesLaenderArray = BundesLaender.values();
            int n = bundesLaenderArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundesLaender blv = bundesLaenderArray[n2];
                if (blv.abkuerzung.toLowerCase().equals(bl.toLowerCase()) || blv.land.toLowerCase().equals(bl.toLowerCase())) {
                    return blv;
                }
                ++n2;
            }
            return UNBEKANNT;
        }

        public String getAbkuerzung() {
            return this.abkuerzung;
        }

        public String getLand() {
            return this.land;
        }
    }
}

