/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.param;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.dav.DavDatenVew;
import de.inovat.buv.projektlib.rechtevew.lib.RechteVew;
import de.inovat.buv.projektlib.rwservice.RWService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;

public class BenutzerFunc {
    private static final String FUNKTION_ID_BENUTZER_PARAM_VEW = "de.inovat.buv.projektlib.funktionen.benutzerparamvew";
    public static final String TXT_ANGEMELDET = "(angemeldet)";
    public static final String BENUTZER_ANGEMELDET_PID;
    public static final SystemObjectType TYP_BENUTZER;

    static {
        SystemObjectType typ = null;
        try {
            typ = DavDatenVew.getInstanz().getDav().getDataModel().getType("typ.benutzer");
        }
        catch (Exception e) {
            Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)"SystemObjectType 'Benutzer' ist nicht ermittelbar.", (Throwable)e);
        }
        TYP_BENUTZER = typ;
        String benutzer = "";
        try {
            benutzer = RWService.getService().getRw().getBenutzer().getPid();
        }
        catch (Exception e) {
            Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)"Angemeldeter Benutzer ist nicht ermittelbar.", (Throwable)e);
        }
        BENUTZER_ANGEMELDET_PID = benutzer;
    }

    public static List<SystemObject> getAlleBenutzer() {
        ArrayList<SystemObject> liste = new ArrayList<SystemObject>();
        if (TYP_BENUTZER != null) {
            liste.addAll(TYP_BENUTZER.getObjects());
            liste.sort(Comparator.comparing(so -> so.getPid().toLowerCase()));
        }
        return liste;
    }

    public static List<String> getAlleBenutzerTxt() {
        ArrayList<String> liste = new ArrayList<String>();
        for (SystemObject so : BenutzerFunc.getAlleBenutzer()) {
            liste.add(BenutzerFunc.getBenutzerTxt(so));
        }
        return liste;
    }

    public static String getBenutzerAngemeldetTxt() {
        return String.format("%s %s", BENUTZER_ANGEMELDET_PID, TXT_ANGEMELDET);
    }

    public static ILabelProvider getBenutzerLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SystemObject) {
                    return BenutzerFunc.getBenutzerTxt((SystemObject)element);
                }
                return super.getText(element);
            }
        };
    }

    public static String getBenutzerPid(String benutzerTxt) {
        if (benutzerTxt.equals(BenutzerFunc.getBenutzerAngemeldetTxt())) {
            return BENUTZER_ANGEMELDET_PID;
        }
        return benutzerTxt;
    }

    public static String getBenutzerTxt(SystemObject benutzer) {
        String pid = benutzer.getPid();
        if (pid.equals(BENUTZER_ANGEMELDET_PID)) {
            return BenutzerFunc.getBenutzerAngemeldetTxt();
        }
        return pid;
    }

    public static boolean istBenutzerAngemeldet(String benutzerInfo) {
        return benutzerInfo != null && (benutzerInfo.equals(BENUTZER_ANGEMELDET_PID) || benutzerInfo.equals(BenutzerFunc.getBenutzerAngemeldetTxt()));
    }

    public static boolean istBenutzerAngemeldet(SystemObject benutzer) {
        return benutzer != null && benutzer.getPid().equals(BENUTZER_ANGEMELDET_PID);
    }

    public static boolean istBenutzerEinstellungenVewErlaubt() {
        return RechteVew.getInstanz().istFunktionFuerAngemeldetenBenutzerErlaubt(FUNKTION_ID_BENUTZER_PARAM_VEW);
    }
}

