/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.param;

import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.inovat.lib.funktionen.Dateien;
import de.inovat.buv.inovat.lib.konstanten.Konstanten;
import de.inovat.buv.projektlib.param.IMapParameter;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class MapParameterDateien<V>
implements IMapParameter<V> {
    private static final String DATEI_TYP = ".xml";
    private final String _ordner;

    public MapParameterDateien(String ordner) {
        this._ordner = ordner;
        try {
            Files.createDirectories(new File(this._ordner).toPath(), new FileAttribute[0]);
        }
        catch (Exception e) {
            Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)String.format("Es ist ein Fehler beim Erstellen des Ordners <%s> aufgetreten.", this._ordner), (Throwable)e);
        }
    }

    private Set<Path> ermittleAlleDateien(String namenAnfang) throws Exception {
        BiPredicate<Path, BasicFileAttributes> matcher = (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.toFile().getName().startsWith(namenAnfang) && path.toFile().getName().endsWith(DATEI_TYP);
        return Files.find(new File(this._ordner).toPath(), 1, matcher, new FileVisitOption[0]).collect(Collectors.toSet());
    }

    @Override
    public Map<String, V> ermittleMap(String mapId, Class<V> klasse) {
        HashMap<String, V> map = new HashMap<String, V>();
        try {
            Set<Path> setDateien = this.ermittleAlleDateien(this.getDateiNamen(mapId, ""));
            for (Path datei : setDateien) {
                V wert = this.ermittleWert(datei, klasse);
                if (wert == null) continue;
                map.put(this.getEintragNamen(mapId, datei), wert);
            }
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Maps <%s> aus der Ordner <%s> aufgetreten.", mapId, this._ordner), (Throwable)e);
        }
        return map;
    }

    private V ermittleWert(Path datei, Class<V> klasse) {
        try {
            Object wertXmlObject = IMapParameter.dekodiereWertAusXml(datei, klasse.getClassLoader());
            if (klasse.isInstance(wertXmlObject)) {
                return klasse.cast(wertXmlObject);
            }
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Werts aus der Datei <%s> aufgetreten: unerwarteter Typ <%s>.", datei, wertXmlObject.getClass().getName()));
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Werts aus der Datei <%s> aufgetreten.", datei), (Throwable)e);
        }
        return null;
    }

    private String getDatei(String mapId, String name) {
        return String.format("%s%s%s%s", this._ordner, Konstanten.FILESEPARATOR, this.getDateiNamen(mapId, name), DATEI_TYP);
    }

    private String getDateiNamen(String mapId, String name) {
        String dateiName = String.format("%s%s%s", mapId, ".", name);
        return Dateien.kodiereTextInDateinamen((String)dateiName);
    }

    private String getEintragNamen(String mapId, Path datei) {
        String name = datei.toFile().getName();
        if ((name = name.replaceFirst(this.getDateiNamen(mapId, ""), "")).endsWith(DATEI_TYP)) {
            name = name.substring(0, name.lastIndexOf(DATEI_TYP));
        }
        return Dateien.dekodiereTextAusDateinamen((String)name);
    }

    @Override
    public boolean loescheEintrag(Map<String, V> map, String mapId, String name) {
        String datei = this.getDatei(mapId, name);
        try {
            if (Files.deleteIfExists(new File(datei).toPath())) {
                map.remove(name);
                return true;
            }
        }
        catch (Exception e) {
            Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)String.format("Es ist ein Fehler beim L\u00f6schen der Datei <%s> aufgetreten.", datei), (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean speichereEintrag(Map<String, V> map, String mapId, String name, V wert) {
        String datei = this.getDatei(mapId, name);
        if (this.speichereWert(new File(datei).toPath(), wert)) {
            map.put(name, wert);
            return true;
        }
        return false;
    }

    private boolean speichereWert(Path datei, V wert) {
        try {
            IMapParameter.kodiereWertInXml(wert, datei);
            return true;
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Speichern des Werts in der Datei <%s> aufgetreten.", datei), (Throwable)e);
            return false;
        }
    }
}

