/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.param;

import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.param.IMapParameter;
import de.inovat.buv.projektlib.rwservice.RWService;
import de.inovat.buv.projektlib.speicher.einstellungen.SpeicherArtUndOrt;
import de.inovat.buv.projektlib.speicher.einstellungen.SpeicherFunktionen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapParameterRwSpeicher<V>
implements IMapParameter<V> {
    static final String ID_ZEITPUNKT = ".syncZeitPunkt";
    static final String ID_TRENNZEICHEN = ".";
    private final String _idTrennZeichen;
    private final RwSpeicher _rwSpeicher;

    public MapParameterRwSpeicher(RwSpeicher rwSpeicher) {
        this(rwSpeicher, ID_TRENNZEICHEN);
    }

    public MapParameterRwSpeicher(RwSpeicher rwSpeicher, String idTrennZeichen) {
        this._idTrennZeichen = idTrennZeichen;
        this._rwSpeicher = rwSpeicher;
    }

    private Set<String> ermittleAlleId() {
        HashSet setId = new HashSet();
        try {
            for (SpeicherKey speicherKey : this._rwSpeicher.getListeSpeicherKey()) {
                Map mapPar = RWService.getService().getEinstellungen().getEinstellungsId(speicherKey);
                setId.addAll(mapPar.keySet());
            }
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("IDs f\u00fcr <%s> k\u00f6nnen nicht gelesen werden.", new Object[]{this._rwSpeicher}), (Throwable)e);
        }
        return setId.stream().filter(s -> !s.endsWith(ID_ZEITPUNKT)).collect(Collectors.toSet());
    }

    private Set<String> ermittleAlleId(String idAnfang) {
        Set<String> setId = this.ermittleAlleId();
        return setId.stream().filter(s -> s.startsWith(idAnfang)).collect(Collectors.toSet());
    }

    @Override
    public Map<String, V> ermittleMap(String mapId, Class<V> klasse) {
        HashMap<String, V> map = new HashMap<String, V>();
        String idAnfang = this.getEintragId(mapId, "");
        Set<String> setId = this.ermittleAlleId(idAnfang);
        for (String id : setId) {
            V wert = this.ermittleWert(id, klasse);
            if (wert == null) continue;
            String idEintrag = id.replaceFirst(idAnfang, "");
            map.put(idEintrag, wert);
        }
        return map;
    }

    private V ermittleWert(String id, Class<V> klasse) {
        String wertXmlString = SpeicherFunktionen.ladeParameter(id, this._rwSpeicher._speicher);
        if (wertXmlString != null) {
            try {
                Object wertXmlObject = IMapParameter.dekodiereWertAusXml(wertXmlString, klasse.getClassLoader());
                if (klasse.isInstance(wertXmlObject)) {
                    return klasse.cast(wertXmlObject);
                }
                Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Werts f\u00fcr <%s> <%s> aufgetreten: unerwarteter Typ <%s>.", new Object[]{this._rwSpeicher, id, wertXmlObject.getClass().getName()}));
            }
            catch (Exception e) {
                Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Werts f\u00fcr <%s> <%s> aufgetreten.", new Object[]{this._rwSpeicher, id}), (Throwable)e);
            }
        }
        return null;
    }

    private String getEintragId(String mapId, String name) {
        return String.format("%s%s%s", mapId, this._idTrennZeichen, name);
    }

    @Override
    public boolean loescheEintrag(Map<String, V> map, String mapId, String name) {
        MapParameterRwSpeicher.pause();
        String id = this.getEintragId(mapId, name);
        UrlasserInfo urlasserInfo = SpeicherFunktionen.erstelleUrlasserInfoObjekt("L\u00f6schen des Parameters");
        if (SpeicherFunktionen.loescheParameter(id, this._rwSpeicher._speicher, urlasserInfo)) {
            map.remove(name);
            return true;
        }
        return false;
    }

    public static void pause() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean speichereEintrag(Map<String, V> map, String mapId, String name, V wert) {
        String id = this.getEintragId(mapId, name);
        if (this.speichereWert(id, wert)) {
            map.put(name, wert);
            return true;
        }
        return false;
    }

    private boolean speichereWert(String id, V wert) {
        MapParameterRwSpeicher.pause();
        try {
            String wertXmlString = IMapParameter.kodiereWertInXml(wert);
            UrlasserInfo urlasserInfo = SpeicherFunktionen.erstelleUrlasserInfoObjekt("Speichern des Parameters");
            return SpeicherFunktionen.speichereParameter(id, this._rwSpeicher._speicher, wertXmlString, urlasserInfo);
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Speichern des Werts f\u00fcr <%s> <%s> aufgetreten.", new Object[]{this._rwSpeicher, id}), (Throwable)e);
            return false;
        }
    }

    public static enum RwSpeicher {
        AllgemeinSync(new SpeicherArtUndOrt(new SpeicherFunktionen.ArtOrt[]{SpeicherFunktionen.ArtOrt.ALLGEMEIN_DAV, SpeicherFunktionen.ArtOrt.ALLGEMEIN_LOKAL}, true)),
        AllgemeinDav(new SpeicherArtUndOrt(new SpeicherFunktionen.ArtOrt[]{SpeicherFunktionen.ArtOrt.ALLGEMEIN_DAV}, false)),
        AllgemeinLokal(new SpeicherArtUndOrt(new SpeicherFunktionen.ArtOrt[]{SpeicherFunktionen.ArtOrt.ALLGEMEIN_LOKAL}, false)),
        BenutzerSync(new SpeicherArtUndOrt(new SpeicherFunktionen.ArtOrt[]{SpeicherFunktionen.ArtOrt.BENUTZER_DAV, SpeicherFunktionen.ArtOrt.BENUTZER_LOKAL}, true)),
        BenutzerDav(new SpeicherArtUndOrt(new SpeicherFunktionen.ArtOrt[]{SpeicherFunktionen.ArtOrt.BENUTZER_DAV}, false)),
        BenutzerLokal(new SpeicherArtUndOrt(new SpeicherFunktionen.ArtOrt[]{SpeicherFunktionen.ArtOrt.BENUTZER_LOKAL}, false));

        public final SpeicherArtUndOrt _speicher;

        private RwSpeicher(SpeicherArtUndOrt speicher) {
            this._speicher = speicher;
        }

        public List<SpeicherKey> getListeSpeicherKey() {
            ArrayList<SpeicherKey> listeSpeicherKey = new ArrayList<SpeicherKey>();
            SpeicherFunktionen.ArtOrt[] artOrtArray = this._speicher.getArArtOrt();
            int n = artOrtArray.length;
            int n2 = 0;
            while (n2 < n) {
                SpeicherFunktionen.ArtOrt artOrt = artOrtArray[n2];
                listeSpeicherKey.add(SpeicherFunktionen.ermittleSpeicher(artOrt));
                ++n2;
            }
            return listeSpeicherKey;
        }
    }
}

