/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.param;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungLocation;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.puk.param.lib.daten.UrlasserInfo;
import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.param.BenutzerFunc;
import de.inovat.buv.projektlib.param.IMapParameter;
import de.inovat.buv.projektlib.param.MapParameterRwSpeicher;
import de.inovat.buv.projektlib.rwservice.RWService;
import de.inovat.buv.projektlib.speicher.einstellungen.SpeicherFunktionen;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapParameterRwSpeicherBenutzer<V>
implements IMapParameter<V> {
    private static final String ID_INITIALISIERUNG = "Speicher-Initialisierung f\u00fcr nicht angemeldete Benutzer";
    private final String _idTrennZeichen;
    private final String _benutzer;
    private final SpeicherKey _speicherKey;

    public MapParameterRwSpeicherBenutzer(String benutzer) {
        this(benutzer, ".");
    }

    public MapParameterRwSpeicherBenutzer(String benutzer, String idTrennZeichen) {
        this._idTrennZeichen = idTrennZeichen;
        this._benutzer = benutzer;
        if (!BenutzerFunc.istBenutzerEinstellungenVewErlaubt()) {
            Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)"Der angemeldete Benutzer darf keine Rahmenwerk-Einstellungen f\u00fcr andere Benutzer \u00e4ndern!");
            this._speicherKey = null;
        } else {
            this._speicherKey = SpeicherKey.of((EinstellungOwnerType)EinstellungOwnerType.BENUTZER, (EinstellungLocation)EinstellungLocation.NETZWERKWEIT, (String)this._benutzer);
            String wertInit = this.ermittleWert(ID_INITIALISIERUNG);
            if (wertInit == null || wertInit.isEmpty()) {
                wertInit = LocalDateTime.of(LocalDate.now(), LocalTime.now()).toString();
                this.speichereWert(ID_INITIALISIERUNG, wertInit);
            }
        }
    }

    private Set<String> ermittleAlleId() {
        HashSet setId = new HashSet();
        try {
            Map mapPar = RWService.getService().getEinstellungen().getEinstellungsId(this._speicherKey);
            setId.addAll(mapPar.keySet());
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("IDs f\u00fcr <%s %s> k\u00f6nnen nicht gelesen werden.", this._speicherKey, this._benutzer), (Throwable)e);
        }
        return setId.stream().filter(s -> !s.endsWith(".syncZeitPunkt")).collect(Collectors.toSet());
    }

    private Set<String> ermittleAlleId(String idAnfang) {
        Set<String> setId = this.ermittleAlleId();
        return setId.stream().filter(s -> s.startsWith(idAnfang)).collect(Collectors.toSet());
    }

    @Override
    public Map<String, V> ermittleMap(String mapId, Class<V> klasse) {
        HashMap<String, V> map = new HashMap<String, V>();
        String idAnfang = this.getEintragId(mapId, "");
        Set<String> setId = this.ermittleAlleId(idAnfang);
        for (String id : setId) {
            V wert = this.ermittleWert(id, klasse);
            if (wert == null) continue;
            String idEintrag = id.replaceFirst(idAnfang, "");
            map.put(idEintrag, wert);
        }
        return map;
    }

    private String ermittleWert(String id) {
        try {
            return RWService.getService().getEinstellungen().getValue(new EinstellungsAdresse(null, id, this._speicherKey)).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private V ermittleWert(String id, Class<V> klasse) {
        String wertXmlString = this.ermittleWert(id);
        if (wertXmlString != null) {
            try {
                Object wertXmlObject = IMapParameter.dekodiereWertAusXml(wertXmlString, klasse.getClassLoader());
                if (klasse.isInstance(wertXmlObject)) {
                    return klasse.cast(wertXmlObject);
                }
                Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Werts f\u00fcr <%s %s> <%s> aufgetreten: unerwarteter Typ <%s>.", this._speicherKey, this._benutzer, id, wertXmlObject.getClass().getName()));
            }
            catch (Exception e) {
                Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Laden des Werts f\u00fcr <%s %s> <%s> aufgetreten.", this._speicherKey, this._benutzer, id), (Throwable)e);
            }
        }
        return null;
    }

    private String getEintragId(String mapId, String name) {
        return String.format("%s%s%s", mapId, this._idTrennZeichen, name);
    }

    @Override
    public boolean loescheEintrag(Map<String, V> map, String mapId, String name) {
        MapParameterRwSpeicher.pause();
        String id = this.getEintragId(mapId, name);
        UrlasserInfo urlasserInfo = SpeicherFunktionen.erstelleUrlasserInfoObjekt("L\u00f6schen des Parameters");
        try {
            RWService.getService().getEinstellungen().removeValue(new EinstellungsAdresse(null, id, this._speicherKey), urlasserInfo);
            map.remove(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean speichereEintrag(Map<String, V> map, String mapId, String name, V wert) {
        String id = this.getEintragId(mapId, name);
        if (this.speichereWertXml(id, wert)) {
            map.put(name, wert);
            return true;
        }
        return false;
    }

    private boolean speichereWert(String id, String wert) {
        MapParameterRwSpeicher.pause();
        try {
            UrlasserInfo urlasserInfo = SpeicherFunktionen.erstelleUrlasserInfoObjekt("Speichern des Parameters");
            RWService.getService().getEinstellungen().setValue(new EinstellungsAdresse(null, id, this._speicherKey), (Object)wert, urlasserInfo);
            return true;
        }
        catch (IOException e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Speichern des Werts f\u00fcr <%s %s> <%s> aufgetreten.", this._speicherKey, this._benutzer, id), (Throwable)e);
            return false;
        }
    }

    private boolean speichereWertXml(String id, V wert) {
        try {
            String wertXmlString = IMapParameter.kodiereWertInXml(wert);
            return this.speichereWert(id, wertXmlString);
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Speichern des Werts f\u00fcr <%s %s> <%s> aufgetreten.", this._speicherKey, this._benutzer, id), (Throwable)e);
            return false;
        }
    }
}

