/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.param.gui.paramuebetragung;

import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.param.IMapParameter;
import de.inovat.buv.projektlib.param.gui.paramuebetragung.IParamInfo;
import de.inovat.buv.projektlib.param.gui.paramuebetragung.ParamUebetragungGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ParamUebetragungGuiVew<V> {
    public static final String ROOT = "Alle";
    public static final String LEER = "- - -";
    private List<Object> _listeLinks = new ArrayList<Object>();
    private List<Object> _listeRechts = new ArrayList<Object>();
    private Map<V, String> _mapLinks = new HashMap<V, String>();
    private Map<V, String> _mapRechts = new HashMap<V, String>();
    private final ParamUebetragungGui<V> _gui;

    ParamUebetragungGuiVew(ParamUebetragungGui<V> gui) {
        this._gui = gui;
    }

    public void btnAktualisierenSelektiert() {
        IRunnableWithProgress run = monitor -> {
            V wert;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            subMonitor.setTaskName("Lesen der Daten links");
            subMonitor.worked(1);
            Map<String, V> mapParLinks = this._gui.getParamInfo().ermittleMap(IParamInfo.Position.Links);
            subMonitor.worked(1);
            subMonitor.setTaskName("Lesen der Daten rechts");
            subMonitor.worked(1);
            Map<String, V> mapParRechts = this._gui.getParamInfo().ermittleMap(IParamInfo.Position.Rechts);
            subMonitor.worked(1);
            subMonitor.setTaskName("Datenvorbereitung");
            TreeSet<String> setNamen = new TreeSet<String>();
            setNamen.addAll(mapParLinks.keySet());
            setNamen.addAll(mapParRechts.keySet());
            this._listeLinks = new ArrayList<Object>();
            this._mapLinks = new HashMap<V, String>();
            for (String name : setNamen) {
                wert = mapParLinks.get(name);
                if (wert != null) {
                    this._listeLinks.add(wert);
                    this._mapLinks.put((String)wert, name);
                    continue;
                }
                this._listeLinks.add(LEER);
            }
            this._listeRechts = new ArrayList<Object>();
            this._mapRechts = new HashMap<V, String>();
            for (String name : setNamen) {
                wert = mapParRechts.get(name);
                if (wert != null) {
                    this._listeRechts.add(wert);
                    this._mapRechts.put((String)wert, name);
                    continue;
                }
                this._listeRechts.add(LEER);
            }
            subMonitor.worked(1);
            Display.getDefault().syncExec(() -> {
                CheckboxTreeViewer[] checkboxTreeViewerArray = new CheckboxTreeViewer[]{this._gui.getTreeViewerLinks(), this._gui.getTreeViewerRechts()};
                int n = checkboxTreeViewerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CheckboxTreeViewer treeViewer = checkboxTreeViewerArray[n2];
                    treeViewer.refresh();
                    treeViewer.expandAll();
                    treeViewer.setCheckedElements(new Object[0]);
                    treeViewer.setGrayedElements(new Object[]{LEER});
                    TreeItem item = treeViewer.getTree().getItem(0);
                    if (item != null) {
                        treeViewer.getTree().setTopItem(item);
                    }
                    ++n2;
                }
                this._gui.getBtnVonLinksKopieren().setEnabled(false);
                this._gui.getBtnVonRechtsKopieren().setEnabled(false);
                this._gui.getBtnLinksLoeschen().setEnabled(false);
                this._gui.getBtnRechtsLoeschen().setEnabled(false);
            });
            subMonitor.worked(1);
        };
        ParamUebetragungGuiVew.starteProgressMonitorDialog("Aktualisieren der Daten", run);
    }

    private void btnKopierenSelektiert(IParamInfo.Position positionQuelle, IParamInfo.Position positionZiel) {
        if (MessageDialog.openConfirm((Shell)this._gui.getShell(), (String)"Parameter kopieren", (String)String.format("Sollen die %s selektierten Parameter nach %s kopiert werden?", positionQuelle.name().toLowerCase(), positionZiel.name().toLowerCase()))) {
            Map<String, Boolean> mapErgebnis = this.kopiereParameter(positionQuelle, positionZiel);
            TreeSet<String> setNichtKopiert = new TreeSet<String>();
            for (String name2 : mapErgebnis.keySet()) {
                if (mapErgebnis.get(name2).booleanValue()) continue;
                setNichtKopiert.add(name2);
            }
            if (mapErgebnis.isEmpty()) {
                MessageDialog.openInformation((Shell)this._gui.getShell(), (String)"Information", (String)"Es sind keine Parameter selektiert.");
            } else if (setNichtKopiert.isEmpty()) {
                MessageDialog.openInformation((Shell)this._gui.getShell(), (String)"Information", (String)String.format("Alle <%s> Parameter wurden erfolgreich kopiert.", mapErgebnis.size()));
            } else {
                StringBuilder txt = new StringBuilder();
                setNichtKopiert.forEach(name -> {
                    StringBuilder stringBuilder2 = txt.append(String.format("%s%n", name));
                });
                Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)String.format("Folgende Parameter wurden nicht kopiert:%n%s", txt));
                MessageDialog.openWarning((Shell)this._gui.getShell(), (String)"Warnung", (String)String.format("Es wurden %s von %s selektierten Parametern kopiert.%n%nFolgende Parameter wurden nicht kopiert (siehe Fehlerprotokoll):%n%s", mapErgebnis.size() - setNichtKopiert.size(), mapErgebnis.size(), txt));
            }
        }
    }

    void btnLinksLoeschenSelektiert() {
        this.loescheParameter(IParamInfo.Position.Links);
    }

    void btnRechtsLoeschenSelektiert() {
        this.loescheParameter(IParamInfo.Position.Rechts);
    }

    void btnVonLinksKopierenSelektiert() {
        this.btnKopierenSelektiert(IParamInfo.Position.Links, IParamInfo.Position.Rechts);
    }

    void btnVonRechtsKopierenSelektiert() {
        this.btnKopierenSelektiert(IParamInfo.Position.Rechts, IParamInfo.Position.Links);
    }

    public Map<String, V> getSelektierteElemente(IParamInfo.Position position) {
        CheckboxTreeViewer treeViewer = position == IParamInfo.Position.Links ? this._gui.getTreeViewerLinks() : this._gui.getTreeViewerRechts();
        LinkedHashSet<Object> setSelektiert = new LinkedHashSet<Object>(Arrays.asList(treeViewer.getCheckedElements()));
        Map<V, String> map = position == IParamInfo.Position.Links ? this._mapLinks : this._mapRechts;
        LinkedHashMap<String, V> mapSelektiert = new LinkedHashMap<String, V>();
        for (Object e : setSelektiert) {
            if (!this._gui.getParamInfo().getKlasse().isInstance(e)) continue;
            V wert = this._gui.getParamInfo().getKlasse().cast(e);
            mapSelektiert.put(map.get(wert), wert);
        }
        return mapSelektiert;
    }

    void initialisiereGui() {
        this._gui.getTreeViewerLinks().setContentProvider((IContentProvider)new TreeContentProvider(IParamInfo.Position.Links));
        this._gui.getTreeViewerLinks().setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(IParamInfo.Position.Links));
        this._gui.getTreeViewerLinks().addCheckStateListener(event -> this.treeViewerCbtnSelektiert(event, IParamInfo.Position.Links));
        this._gui.getTreeViewerLinks().setInput((Object)new String[]{ROOT});
        this._gui.getTreeViewerLinks().expandAll();
        this._gui.getTreeViewerRechts().setContentProvider((IContentProvider)new TreeContentProvider(IParamInfo.Position.Rechts));
        this._gui.getTreeViewerRechts().setLabelProvider((IBaseLabelProvider)new TreeLabelProvider(IParamInfo.Position.Rechts));
        this._gui.getTreeViewerRechts().addCheckStateListener(event -> this.treeViewerCbtnSelektiert(event, IParamInfo.Position.Rechts));
        this._gui.getTreeViewerRechts().setInput((Object)new String[]{ROOT});
        this._gui.getTreeViewerRechts().expandAll();
        this._gui.getLbParamNameLinks().setText(this._gui.getParamInfo().getBezeichnung(IParamInfo.Position.Links));
        this._gui.getLbParamNameRechts().setText(this._gui.getParamInfo().getBezeichnung(IParamInfo.Position.Rechts));
        this.btnAktualisierenSelektiert();
    }

    public Map<String, Boolean> kopiereParameter(IParamInfo.Position positionQuelle, IParamInfo.Position positionZiel) {
        TreeMap<String, Boolean> mapErgebnis = new TreeMap<String, Boolean>();
        Map<String, V> mapSelektiert = this.getSelektierteElemente(positionQuelle);
        for (String name : mapSelektiert.keySet()) {
            mapErgebnis.put(name, false);
        }
        if (mapErgebnis.isEmpty()) {
            return mapErgebnis;
        }
        IRunnableWithProgress run = monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(mapSelektiert.size() + 1));
            subMonitor.setTaskName("Kopieren der Daten ... ");
            subMonitor.worked(1);
            IMapParameter parVewZiel = this._gui.getParamInfo().getMapParameter(positionZiel);
            for (String name : mapSelektiert.keySet()) {
                subMonitor.setTaskName(String.format("Kopieren des Parameters: %s", name));
                if (parVewZiel.speichereEintrag(new HashMap(), this._gui.getParamInfo().getMapId(positionZiel), name, mapSelektiert.get(name))) {
                    mapErgebnis.put(name, true);
                }
                subMonitor.worked(1);
            }
        };
        ParamUebetragungGuiVew.starteProgressMonitorDialog("Kopieren der Daten", run);
        this.btnAktualisierenSelektiert();
        return mapErgebnis;
    }

    private void loescheParameter(IParamInfo.Position position) {
        if (MessageDialog.openConfirm((Shell)this._gui.getShell(), (String)"Parameter l\u00f6schen", (String)String.format("Sollen die %s selektierten Parameter gel\u00f6scht werden?", position.name().toLowerCase()))) {
            Map<String, V> mapSelektiert = this.getSelektierteElemente(position);
            IRunnableWithProgress run = monitor -> {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(mapSelektiert.size() + 1));
                subMonitor.setTaskName("L\u00f6schen der Daten ...");
                subMonitor.worked(1);
                IMapParameter parVew = this._gui.getParamInfo().getMapParameter(position);
                int anz = 0;
                for (String name : mapSelektiert.keySet()) {
                    subMonitor.setTaskName(String.format("L\u00f6schen des Parameters: %s", name));
                    if (parVew.loescheEintrag(new HashMap(), this._gui.getParamInfo().getMapId(position), name)) {
                        ++anz;
                    }
                    subMonitor.worked(1);
                }
                int finalAnz = anz;
                Display.getDefault().syncExec(() -> {
                    if (finalAnz == mapSelektiert.size()) {
                        MessageDialog.openInformation((Shell)this._gui.getShell(), (String)"Information", (String)String.format("Alle <%s> Parameter wurden erfolgreich gel\u00f6scht.", finalAnz));
                    } else {
                        MessageDialog.openWarning((Shell)this._gui.getShell(), (String)"Warnung", (String)String.format("Es wurden %s von %s selektierten Parametern gel\u00f6scht (siehe Fehlerprotokoll).", finalAnz, mapSelektiert.size()));
                    }
                });
            };
            ParamUebetragungGuiVew.starteProgressMonitorDialog("L\u00f6schen der Daten", run);
            this.btnAktualisierenSelektiert();
        }
    }

    public void selektiereElemente(IParamInfo.Position position, Collection<V> elemente) {
        CheckboxTreeViewer treeViewer = position == IParamInfo.Position.Links ? this._gui.getTreeViewerLinks() : this._gui.getTreeViewerRechts();
        treeViewer.setCheckedElements(elemente.toArray(new Object[0]));
        this.treeViewerCbtnSelektiert(new CheckStateChangedEvent((ICheckable)treeViewer, elemente, true), position);
    }

    public static boolean starteProgressMonitorDialog(final String titel, IRunnableWithProgress run) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell()){

            protected void createCancelButton(Composite parent) {
                super.createCancelButton(parent);
                this.getButton(1).setVisible(false);
            }

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(titel);
            }
        };
        try {
            dialog.run(true, true, run);
            return true;
        }
        catch (Exception e) {
            Log.zeigeInterneMeldung((String)"de.inovat.buv.projektlib", (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)String.format("Es sind Probleme im Prozess '%s' aufgetreten %n(siehe Fehlerprotokoll)", titel));
            return false;
        }
    }

    void treeVerticalScrollBarSelektiert(IParamInfo.Position position) {
        Tree tree_1 = position == IParamInfo.Position.Links ? this._gui.getTreeViewerLinks().getTree() : this._gui.getTreeViewerRechts().getTree();
        Tree tree_2 = position == IParamInfo.Position.Links ? this._gui.getTreeViewerRechts().getTree() : this._gui.getTreeViewerLinks().getTree();
        try {
            TreeItem treeItem = tree_1.getTopItem();
            ArrayList<Integer> listeIndex = new ArrayList<Integer>();
            while (treeItem.getParentItem() != null) {
                listeIndex.add(0, treeItem.getParentItem().indexOf(treeItem));
                treeItem = treeItem.getParentItem();
            }
            listeIndex.add(0, tree_1.indexOf(treeItem));
            treeItem = tree_2.getItem(((Integer)listeIndex.remove(0)).intValue());
            for (Integer index : listeIndex) {
                treeItem = treeItem.getItem(index.intValue());
            }
            tree_2.setTopItem(treeItem);
        }
        catch (Exception e) {
            Log.zeige((int)2, (String)"de.inovat.buv.projektlib", (String)"Fehler beim Synchronisieren der Scroll-Balken passiert", (Throwable)e);
        }
    }

    private void treeViewerCbtnSelektiert(CheckStateChangedEvent event, IParamInfo.Position position) {
        CheckboxTreeViewer treeViewer;
        CheckboxTreeViewer checkboxTreeViewer = treeViewer = position == IParamInfo.Position.Links ? this._gui.getTreeViewerLinks() : this._gui.getTreeViewerRechts();
        if (event.getElement() == ROOT) {
            List<Object> liste;
            boolean selektiert = event.getChecked();
            List<Object> list = liste = position == IParamInfo.Position.Links ? this._listeLinks : this._listeRechts;
            if (selektiert) {
                treeViewer.setCheckedElements(liste.toArray());
                treeViewer.setChecked((Object)ROOT, true);
            } else {
                treeViewer.setCheckedElements(new Object[0]);
            }
        }
        Map<String, V> mapSelektiert = this.getSelektierteElemente(position);
        if (event.getElement() != ROOT) {
            Map<V, String> map = position == IParamInfo.Position.Links ? this._mapLinks : this._mapRechts;
            treeViewer.setChecked((Object)ROOT, mapSelektiert.size() == map.size());
        }
        Button btn1 = position == IParamInfo.Position.Links ? this._gui.getBtnVonLinksKopieren() : this._gui.getBtnVonRechtsKopieren();
        btn1.setEnabled(!mapSelektiert.isEmpty());
        Button btn2 = position == IParamInfo.Position.Links ? this._gui.getBtnLinksLoeschen() : this._gui.getBtnRechtsLoeschen();
        btn2.setEnabled(!mapSelektiert.isEmpty());
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private final IParamInfo.Position _position;

        TreeContentProvider(IParamInfo.Position position) {
            this._position = position;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == ParamUebetragungGuiVew.ROOT) {
                if (this._position == IParamInfo.Position.Links) {
                    return ParamUebetragungGuiVew.this._listeLinks.toArray();
                }
                return ParamUebetragungGuiVew.this._listeRechts.toArray();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection inputCollection = (Collection)inputElement;
                return inputCollection.toArray();
            }
            if (inputElement.getClass().isArray()) {
                return (Object[])inputElement;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element != ParamUebetragungGuiVew.ROOT) {
                return ParamUebetragungGuiVew.ROOT;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element == ParamUebetragungGuiVew.ROOT;
        }
    }

    private class TreeLabelProvider
    extends LabelProvider {
        private final IParamInfo.Position _position;

        TreeLabelProvider(IParamInfo.Position position) {
            this._position = position;
        }

        public String getText(Object element) {
            Map map = this._position == IParamInfo.Position.Links ? ParamUebetragungGuiVew.this._mapLinks : ParamUebetragungGuiVew.this._mapRechts;
            String name = (String)map.get(element);
            if (name != null) {
                return name;
            }
            return element.toString();
        }
    }
}

