/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.rechtevew.aktionen;

import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.inovat.lib.gui.GuiFunktionen;
import de.inovat.buv.projektlib.rechtevew.lib.RechteVew;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class AktionenVew {
    private static AktionenVew instanz = new AktionenVew();
    private int _anzahlSichte = 0;

    private AktionenVew() {
    }

    public Exception ausfuehrenAktion(String aktionId) {
        try {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            handlerService.executeCommand(aktionId, null);
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public boolean ausfuehrenAktionMitDebugausgabe(String aktionId) {
        Exception exception = this.ausfuehrenAktion(aktionId);
        if (exception == null) {
            return true;
        }
        Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)"Aktion kann nicht ausgef\u00fchrt werden", (Throwable)exception));
        return false;
    }

    public void erstelleLeeresGui(Composite parent, String text) {
        parent.setLayout((Layout)new GridLayout());
        new Label(parent, 0);
        new Label(parent, 0);
        Label lb = new Label(parent, 0);
        lb.setText(text);
        parent.layout();
        parent.getParent().layout();
    }

    public static AktionenVew getInstanz() {
        return instanz;
    }

    public boolean perspektiveOeffnen(String perspektiveId, boolean perspektiveZuruecksetzen) {
        try {
            IPerspectiveDescriptor pers = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspektiveId);
            if (pers != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(pers);
                if (perspektiveZuruecksetzen) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().resetPerspective();
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(String.valueOf(perspektiveId) + " Perspective kann nicht angezeigt werden!");
            e.printStackTrace();
            return false;
        }
    }

    public void perspektiveZuruecksetzen(String perspektiveId) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals(perspektiveId)) {
            workbench.getActiveWorkbenchWindow().getActivePage().resetPerspective();
        } else {
            IPerspectiveDescriptor pers = workbench.getPerspectiveRegistry().findPerspectiveWithId(perspektiveId);
            if (pers != null) {
                workbench.getPerspectiveRegistry().revertPerspective(pers);
            }
        }
    }

    public boolean pruefeRechtFuerSicht(String funktion, final Composite parent, final boolean parentReinigen, final String viewTitel) {
        if (!RechteVew.getInstanz().istFunktionFuerAngemeldetenBenutzerErlaubt(funktion)) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Composite parentNeu;
                    if (parentReinigen) {
                        Composite viewComposite = parent.getParent();
                        parent.dispose();
                        parentNeu = new Composite(viewComposite, 0);
                    } else {
                        parentNeu = parent;
                    }
                    AktionenVew.this.erstelleLeeresGui(parentNeu, String.format("ACHTUNG:%n%nSie haben f\u00fcr diese Sicht <%s> nicht die notwendigen Benutzerrechte! %n%n\u00c4ndern Sie gegebenenfalls die Rechte und schlie\u00dfen Sie die Sicht! %nGe\u00e4nderte Rechte werden erst nach dem Schlie\u00dfen und Neu\u00f6ffnen der Sicht wirksam.", viewTitel));
                }
            });
            return false;
        }
        return true;
    }

    public void schliesseSichtBeiRechtSperrung(String funktion, final String viewId, final String viewIdSecond, final String viewTitel, final boolean meldungZeigen) {
        if (!RechteVew.getInstanz().istFunktionFuerAngemeldetenBenutzerErlaubt(funktion)) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewIdSecond != null) {
                        GuiFunktionen.schliesseSichtMulti((String)viewId, (String)viewIdSecond);
                    } else {
                        GuiFunktionen.schliesseSicht((String)viewId);
                    }
                    if (meldungZeigen) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Achtung", (String)String.format("Sie haben kein Recht mit dem GUI <%s> zu arbeiten! %n%nDie Sicht wird geschlossen!", viewTitel));
                    }
                }
            });
        }
    }

    public boolean zeigeSicht(String sichtId) {
        try {
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            workbenchPage.showView(sichtId);
        }
        catch (Exception e) {
            Log.zeigeInterneMeldung((String)"de.inovat.buv.projektlib", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean zeigeSichtMulti(String sichtId) {
        ++this._anzahlSichte;
        return this.zeigeSichtMulti(sichtId, String.valueOf(sichtId) + this._anzahlSichte);
    }

    public boolean zeigeSichtMulti(String sichtId, String sichtSecondId) {
        try {
            IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            workbenchPage.showView(sichtId, sichtSecondId, 1);
        }
        catch (Exception e) {
            Log.zeigeInterneMeldung((String)"de.inovat.buv.projektlib", (Throwable)e);
            return false;
        }
        return true;
    }
}

