/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.rechtevew.lib;

import de.bsvrz.buv.rw.basislib.berechtigung.BerechtigungEreignis;
import de.bsvrz.buv.rw.basislib.berechtigung.Berechtigungen;
import de.bsvrz.buv.rw.basislib.berechtigung.FunktionMitBerechtigung;
import de.bsvrz.buv.rw.basislib.berechtigung.IBerechtigungListener;
import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.rechtevew.lib.IRechteAenderung;
import de.inovat.buv.projektlib.rwservice.RWService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;

public final class RechteVew
implements IBerechtigungListener {
    private static Berechtigungen berechtigungen = RWService.getService().getBerechtigungen();
    private static RechteVew instanz = new RechteVew();
    private static final Map<String, Map<IRechteAenderung, Boolean>> mapRechteListener = new HashMap<String, Map<IRechteAenderung, Boolean>>();

    private RechteVew() {
        berechtigungen.addOberflaechenFunktionsListener((IBerechtigungListener)this);
    }

    public static void addRechteListener(IRechteAenderung klasse) {
        berechtigungen.addOberflaechenFunktionsListener((IBerechtigungListener)klasse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRechteListener(IRechteAenderung klasse, List<String> listeFunktionenId) {
        for (String funkId : listeFunktionenId) {
            FunktionMitBerechtigung funk = berechtigungen.getFunktion(funkId);
            if (funk != null) {
                Map<String, Map<IRechteAenderung, Boolean>> map = mapRechteListener;
                synchronized (map) {
                    Map<IRechteAenderung, Boolean> mapRechte = mapRechteListener.get(funkId);
                    if (mapRechte == null) {
                        mapRechte = new HashMap<IRechteAenderung, Boolean>();
                        mapRechteListener.put(funkId, mapRechte);
                    }
                    mapRechte.put(klasse, null);
                    continue;
                }
            }
            Log.zeige((IStatus)Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Regestrieren der Klasse <%s> als Listener auf Rechte\u00e4nderungen: undefinierte Funktion <%s>", klasse.getClass().getName(), funkId)));
        }
    }

    public static void addRechteListener(IRechteAenderung klasse, String funktionId) {
        ArrayList<String> listeFunktionenId = new ArrayList<String>();
        listeFunktionenId.add(funktionId);
        RechteVew.addRechteListener(klasse, listeFunktionenId);
    }

    public void freigabe(BerechtigungEreignis e) {
        this.rechteGeaendert(e);
    }

    public static RechteVew getInstanz() {
        return instanz;
    }

    public boolean istFunktionFuerAngemeldetenBenutzerErlaubt(String funktionId) {
        FunktionMitBerechtigung funk = berechtigungen.getFunktion(funktionId);
        if (funk != null) {
            return berechtigungen.hasBerechtigung(funk);
        }
        Log.zeige((IStatus)Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Ermitteln der Berechtigung: undefinierte Funktion <%s>", funktionId)));
        return false;
    }

    public boolean istFunktionFuerBenutzerErlaubt(String benutzerPid, String funktionId) {
        FunktionMitBerechtigung funk = berechtigungen.getFunktion(funktionId);
        if (funk != null) {
            return berechtigungen.hasBerechtigung(benutzerPid, funk);
        }
        Log.zeige((IStatus)Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Ermitteln der Berechtigung: undefinierte Funktion <%s>", funktionId)));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rechteGeaendert(BerechtigungEreignis e) {
        Map<String, Map<IRechteAenderung, Boolean>> map = mapRechteListener;
        synchronized (map) {
            for (FunktionMitBerechtigung funk : e.getFunktionen()) {
                Map<IRechteAenderung, Boolean> mapRechte = mapRechteListener.get(funk.getId());
                if (mapRechte == null) continue;
                Boolean rechtNeu = this.istFunktionFuerAngemeldetenBenutzerErlaubt(funk.getId());
                for (IRechteAenderung klasse : mapRechte.keySet()) {
                    Boolean rechtAlt = mapRechte.put(klasse, rechtNeu);
                    if (rechtNeu.equals(rechtAlt)) continue;
                    BerechtigungEreignis ereignis = new BerechtigungEreignis((Object)this, rechtNeu.booleanValue(), null, Collections.singleton(funk));
                    if (rechtNeu.booleanValue()) {
                        klasse.freigabe(ereignis);
                        continue;
                    }
                    klasse.sperrung(ereignis);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRechteListener(IRechteAenderung klasse) {
        Map<String, Map<IRechteAenderung, Boolean>> map = mapRechteListener;
        synchronized (map) {
            HashSet<String> funktionenLoeschen = new HashSet<String>();
            for (String funkId : mapRechteListener.keySet()) {
                Map<IRechteAenderung, Boolean> mapRechte = mapRechteListener.get(funkId);
                mapRechte.remove(klasse);
                if (!mapRechte.isEmpty()) continue;
                funktionenLoeschen.add(funkId);
            }
            for (String funkId : funktionenLoeschen) {
                mapRechteListener.remove(funkId);
            }
        }
    }

    public void sperrung(BerechtigungEreignis e) {
        this.rechteGeaendert(e);
    }
}

