/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.speicher;

import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.inovat.lib.konstanten.Konstanten;
import de.inovat.buv.projektlib.bundesland.BundeslandVew;
import de.inovat.buv.projektlib.dav.DavDatenVew;
import de.inovat.buv.projektlib.konstanten.Zustaende;
import de.inovat.buv.projektlib.speicher.GrundEinstellungen;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OrdnerEinstellungen {
    private static final String ORDNER_TEMP = "inovatTemp";
    public static final boolean IST_AUSGABE_UNTER_ORDNER_EINGESCHALTET = DavDatenVew.getInstanz().getAufrufParameterAlsBoolean("-inovatUnterOrdnerAnlegen", false);
    private static String ORDNER_BENUTZER;
    private static final String UNTERORDNER_PROJEKT_AUSGABE;

    static {
        UNTERORDNER_PROJEKT_AUSGABE = IST_AUSGABE_UNTER_ORDNER_EINGESCHALTET ? String.format("%s_Ausgabe%s%s", Zustaende.PROJEKT_NAME, Konstanten.FILESEPARATOR, BundeslandVew.getInstanz().getBundesland().getAbkuerzung()) : "";
        OrdnerEinstellungen.initialisiereBenutzerOrdner();
    }

    public static String ermittleDefaultBenutzerOrdner() {
        String ordner = DavDatenVew.getInstanz().getAufrufParameterAlsString("-defaultBenutzerOrdner");
        if (ordner == null) {
            ordner = System.getProperty("user.home");
        }
        if (ordner == null) {
            ordner = String.format("D:%s", Konstanten.FILESEPARATOR);
        }
        return ordner;
    }

    private static String ermittleProjektAusgabenOrdner() {
        String ordner = ORDNER_BENUTZER.lastIndexOf(Konstanten.FILESEPARATOR) == ORDNER_BENUTZER.length() - Konstanten.FILESEPARATOR.length() ? (IST_AUSGABE_UNTER_ORDNER_EINGESCHALTET ? String.format("%s%s", ORDNER_BENUTZER, UNTERORDNER_PROJEKT_AUSGABE) : ORDNER_BENUTZER.substring(0, ORDNER_BENUTZER.length() - Konstanten.FILESEPARATOR.length())) : (IST_AUSGABE_UNTER_ORDNER_EINGESCHALTET ? String.format("%s%s%s", ORDNER_BENUTZER, Konstanten.FILESEPARATOR, UNTERORDNER_PROJEKT_AUSGABE) : ORDNER_BENUTZER);
        OrdnerEinstellungen.erzeugeOrdner(ordner);
        return ordner;
    }

    public static String ermittleProjektAusgabenUnterOrdner(String unterOrdner) {
        String ordner = String.format("%s%s%s", OrdnerEinstellungen.ermittleProjektAusgabenOrdner(), Konstanten.FILESEPARATOR, unterOrdner);
        OrdnerEinstellungen.erzeugeOrdner(ordner);
        return ordner;
    }

    public static String ermittleTempOrdner() {
        String ordner = ORDNER_BENUTZER.lastIndexOf(Konstanten.FILESEPARATOR) == ORDNER_BENUTZER.length() - Konstanten.FILESEPARATOR.length() ? String.format("%s%s", ORDNER_BENUTZER, ORDNER_TEMP) : String.format("%s%s%s", ORDNER_BENUTZER, Konstanten.FILESEPARATOR, ORDNER_TEMP);
        OrdnerEinstellungen.erzeugeOrdner(ordner);
        return ordner;
    }

    public static boolean erzeugeOrdner(String ordner) {
        File file = new File(ordner);
        if (!file.exists()) {
            try {
                file.mkdirs();
                return true;
            }
            catch (SecurityException e) {
                Log.zeigeInterneMultiMeldung((String)"de.inovat.buv.projektlib", (String)String.format("Der Ordner <%s> kann nicht erstellt werden!", ordner), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void initialisiereBenutzerOrdner() {
        String ordner = GrundEinstellungen.ermittleParameterWertFuerBenutzer("de.inovat.buv.projektlib.benutzerOrdner");
        if (ordner == null) {
            ordner = OrdnerEinstellungen.ermittleDefaultBenutzerOrdner();
        }
        ORDNER_BENUTZER = ordner;
        OrdnerEinstellungen.erzeugeOrdner(ordner);
        if (!OrdnerEinstellungen.istOrdnerSchreibbar(OrdnerEinstellungen.ermittleTempOrdner())) {
            String text = String.format("Sie haben keine Schreibrechte f\u00fcr den Ordner <%s>!%s%sBitte, einen anderen Ordner f\u00fcr die Einstellungen w\u00e4hlen!%s%sNeuer Ordner kann \u00fcber die Pr\u00e4ferenzen -> inovat -> Datei Speicherstelle definiert werden.", ordner, Konstanten.NEWLINE, Konstanten.NEWLINE, Konstanten.NEWLINE, Konstanten.NEWLINE);
            Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)text));
            try {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)text);
            }
            catch (Exception e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    try {
                        Shell shell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)text);
                    }
                    catch (Exception e2) {
                        Log.zeigeInterneMeldung((String)"de.inovat.buv.projektlib", (Throwable)e2);
                    }
                });
            }
        }
    }

    private static boolean istOrdnerSchreibbar(String ordnerName) {
        boolean ergebnis = true;
        File ordner = new File(ordnerName);
        try {
            File.createTempFile("datei_", null, ordner).deleteOnExit();
        }
        catch (IOException e) {
            ergebnis = false;
        }
        return ergebnis;
    }

    public static void loescheTempOrdner() {
        try {
            File ordner = new File(OrdnerEinstellungen.ermittleTempOrdner());
            File[] ar = ordner.listFiles();
            if (ar != null) {
                File[] fileArray = ar;
                int n = ar.length;
                int n2 = 0;
                while (n2 < n) {
                    File datei = fileArray[n2];
                    datei.delete();
                    ++n2;
                }
            }
            ordner.delete();
        }
        catch (Error | Exception e) {
            Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)"Die Dateien im Tempordner k\u00f6nnen nicht gel\u00f6scht werden!", (Throwable)e));
        }
    }
}

