/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.speicher;

import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.speicher.GrundEinstellungen;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.IStatus;

public class Persistenz {
    private static final Charset UTF_8;
    public static final Charset KODIERUNG;
    public static final Charset KODIERUNG_EXPORT;
    public static final Charset KODIERUNG_KOMPATIBILITAET;

    static {
        KODIERUNG = UTF_8 = StandardCharsets.UTF_8;
        KODIERUNG_EXPORT = UTF_8;
        KODIERUNG_KOMPATIBILITAET = Charset.forName("windows-1252");
    }

    private static Object ermittleXmlParameterWert(String parameter, ClassLoader classLoader, boolean alleBenutzer) {
        String wertXmlString = alleBenutzer ? GrundEinstellungen.ermittleParameterWertFuerAlleBenutzer(parameter) : GrundEinstellungen.ermittleParameterWertFuerBenutzer(parameter);
        if (wertXmlString != null) {
            try {
                wertXmlString = new String(wertXmlString.getBytes(KODIERUNG_KOMPATIBILITAET));
                ByteArrayInputStream input = new ByteArrayInputStream(wertXmlString.getBytes());
                XMLDecoder decoder = new XMLDecoder(input, null, null, classLoader);
                decoder.setExceptionListener(e -> Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Dekodieren des Parameters <%s> aufgetreten!", parameter), (Throwable)e));
                Object wertObject = decoder.readObject();
                decoder.close();
                return wertObject;
            }
            catch (Exception e2) {
                Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)"Projektvoreinstellungen k\u00f6nnen nicht geladen werden!", (Throwable)e2));
            }
        }
        return null;
    }

    public static Object ermittleXmlParameterWertFuerAlleBenutzer(String parameter, ClassLoader classLoader) {
        return Persistenz.ermittleXmlParameterWert(parameter, classLoader, true);
    }

    public static Object ermittleXmlParameterWertFuerBenutzer(String parameter, ClassLoader classLoader) {
        return Persistenz.ermittleXmlParameterWert(parameter, classLoader, false);
    }

    private static boolean speichereXmlParameter(String parameter, Object wert, String ursache, boolean alleBenutzer) {
        boolean gespeichert = false;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(out, StandardCharsets.UTF_8.name(), true, 0);
            encoder.setExceptionListener(e -> Log.zeige((int)4, (String)"de.inovat.buv.projektlib", (String)String.format("Fehler beim Kodieren des Parameters <%s> aufgetreten!", parameter), (Throwable)e));
            encoder.writeObject(wert);
            encoder.close();
            String wertXmlString = new String(out.toByteArray(), KODIERUNG_KOMPATIBILITAET);
            gespeichert = alleBenutzer ? GrundEinstellungen.speichereParameterFuerAlleBenutzer(parameter, wertXmlString, ursache) : GrundEinstellungen.speichereParameterFuerBenutzer(parameter, wertXmlString, ursache);
        }
        catch (Exception e2) {
            Log.zeige((IStatus)Log.erzeugeMeldung((int)4, (String)"de.inovat.buv.projektlib", (String)"Es ist ein Fehler beim Speichern der Projektvoreinstellungen aufgetreten", (Throwable)e2));
        }
        return gespeichert;
    }

    public static boolean speichereXmlParameterFuerAlleBenutzer(String parameter, Object wert, String ursache) {
        return Persistenz.speichereXmlParameter(parameter, wert, ursache, true);
    }

    public static boolean speichereXmlParameterFuerBenutzer(String parameter, Object wert, String ursache) {
        return Persistenz.speichereXmlParameter(parameter, wert, ursache, false);
    }
}

