/*
 * Decompiled with CFR 0.152.
 */
package de.inovat.buv.projektlib.speicher.einstellungen;

import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungsAdresse;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.urlasser.DefaultDatenSender;
import de.bsvrz.buv.rw.basislib.urlasser.DefaultUrlasserInfoDatenSender;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserDatenDialog;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserDatenSender;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfo;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenDialog;
import de.bsvrz.buv.rw.basislib.urlasser.UrlasserInfoDatenSender;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.inovat.buv.inovat.lib.debug.Log;
import de.inovat.buv.projektlib.rwservice.RWService;
import de.inovat.buv.projektlib.speicher.einstellungen.SpeicherArtUndOrt;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SpeicherFunktionen {
    private static final String ID_ZEITPUNKT = ".syncZeitPunkt";
    private static final Boolean SPEICHER_PROZESS_SYNC = true;

    private static ArtOrt ermittleAktuellsteSpeicherArt(String parameterID, SpeicherArtUndOrt speicherArtOrt) {
        int anz = speicherArtOrt.getArArtOrt().length;
        long[] arZeitpunkt = new long[anz];
        int i = 0;
        while (i < anz) {
            arZeitpunkt[i] = SpeicherFunktionen.ermittleDatum(parameterID, speicherArtOrt.getArArtOrt()[i]);
            ++i;
        }
        boolean istDatumGleich = true;
        ArtOrt aktArtOrt = speicherArtOrt.getArArtOrt()[0];
        long maxDatum = arZeitpunkt[0];
        int i2 = 1;
        while (i2 < anz) {
            if (maxDatum < arZeitpunkt[i2]) {
                maxDatum = arZeitpunkt[i2];
                aktArtOrt = speicherArtOrt.getArArtOrt()[i2];
                istDatumGleich = false;
            } else if (maxDatum > arZeitpunkt[i2]) {
                istDatumGleich = false;
            }
            ++i2;
        }
        if (istDatumGleich) {
            aktArtOrt = null;
        }
        return aktArtOrt;
    }

    private static String ermittleBeschreibung(ArtOrt artOrt) {
        switch (artOrt) {
            case BENUTZER_DAV: {
                return "f\u00fcr den Benutzer global";
            }
            case BENUTZER_LOKAL: {
                return "f\u00fcr den Benutzer lokal";
            }
            case ALLGEMEIN_DAV: {
                return "allgemein global";
            }
            case ALLGEMEIN_LOKAL: {
                return "allgemein lokal";
            }
        }
        return "";
    }

    private static long ermittleDatum(String parameterID, ArtOrt artOrt) {
        try {
            SpeicherKey speicher = SpeicherFunktionen.ermittleSpeicher(artOrt);
            if (speicher != null) {
                String datum = RWService.getService().getEinstellungen().getValue(new EinstellungsAdresse(null, String.valueOf(parameterID) + ID_ZEITPUNKT, speicher)).toString();
                return Long.parseLong(datum);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public static SpeicherKey ermittleSpeicher(ArtOrt artOrt) {
        switch (artOrt) {
            case BENUTZER_DAV: {
                return SpeicherKey.benutzerNetzweit();
            }
            case BENUTZER_LOKAL: {
                return SpeicherKey.benutzerLokal();
            }
            case ALLGEMEIN_DAV: {
                return SpeicherKey.allgemeinNetzweit();
            }
            case ALLGEMEIN_LOKAL: {
                return SpeicherKey.allgemeinLokal();
            }
        }
        return null;
    }

    @Deprecated
    public static UrlasserInfo erstelleUrlasserInfo(String ursache) {
        SystemObject benutzer = RWService.getService().getRw().getBenutzer();
        String passwort = RWService.getService().getRw().getPasswort();
        return new UrlasserInfo(benutzer, passwort, ursache, benutzer.getName());
    }

    public static de.bsvrz.puk.param.lib.daten.UrlasserInfo erstelleUrlasserInfoObjekt(String ursache) {
        SystemObject benutzer = RWService.getService().getRw().getBenutzer();
        String passwort = RWService.getService().getRw().getPasswort();
        return new de.bsvrz.puk.param.lib.daten.UrlasserInfo(benutzer, passwort, ursache, benutzer.getName());
    }

    public static String ladeParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt) {
        String parameter;
        block7: {
            block8: {
                SpeicherKey speicher;
                parameter = null;
                if (parameterID == null) break block7;
                if (!speicherArtOrt.isSynchronisieren()) break block8;
                ArtOrt aktArtOrt = SpeicherFunktionen.ermittleAktuellsteSpeicherArt(parameterID, speicherArtOrt);
                boolean isSynchronisieren = true;
                if (aktArtOrt == null) {
                    aktArtOrt = speicherArtOrt.getArArtOrt()[0];
                    isSynchronisieren = false;
                }
                if ((speicher = SpeicherFunktionen.ermittleSpeicher(aktArtOrt)) == null) break block7;
                try {
                    parameter = RWService.getService().getEinstellungen().getValue(new EinstellungsAdresse(null, parameterID, speicher)).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!isSynchronisieren) break block7;
                de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo = SpeicherFunktionen.erstelleUrlasserInfoObjekt(String.format("Synchronisieren des Einstellungsparameters <%s>", parameterID));
                SpeicherFunktionen.speichere(parameterID, speicherArtOrt, parameter, urlasserInfo);
                break block7;
            }
            ArtOrt[] artOrtArray = speicherArtOrt.getArArtOrt();
            int n = artOrtArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArtOrt artOrt = artOrtArray[n2];
                SpeicherKey speicher = SpeicherFunktionen.ermittleSpeicher(artOrt);
                if (speicher != null) {
                    try {
                        parameter = RWService.getService().getEinstellungen().getValue(new EinstellungsAdresse(null, parameterID, speicher)).toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (parameter != null) break;
                ++n2;
            }
        }
        return parameter;
    }

    public static Boolean ladeParameterAlsBoolean(String parameterID, SpeicherArtUndOrt speicherArtOrt) {
        Boolean boolWert = null;
        String text = SpeicherFunktionen.ladeParameter(parameterID, speicherArtOrt);
        if (text != null) {
            try {
                boolWert = Boolean.valueOf(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolWert;
    }

    public static Integer ladeParameterAlsInteger(String parameterID, SpeicherArtUndOrt speicherArtOrt) {
        Integer intWert = null;
        String text = SpeicherFunktionen.ladeParameter(parameterID, speicherArtOrt);
        if (text != null) {
            try {
                intWert = Integer.valueOf(text);
            }
            catch (NumberFormatException e) {
                intWert = 0;
            }
        }
        return intWert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loescheParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt) {
        ArrayList<IStatus> listeWarnungen = new ArrayList<IStatus>();
        Boolean bl = SPEICHER_PROZESS_SYNC;
        synchronized (bl) {
            if (parameterID != null) {
                ArtOrt[] artOrtArray = speicherArtOrt.getArArtOrt();
                int n = artOrtArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtOrt artOrt = artOrtArray[n2];
                    SpeicherKey speicher = SpeicherFunktionen.ermittleSpeicher(artOrt);
                    if (speicher != null) {
                        try {
                            RWService.getService().getEinstellungen().removeValue(new EinstellungsAdresse(null, parameterID, speicher));
                        }
                        catch (Exception e) {
                            listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gel\u00f6scht werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt)), (Throwable)e));
                        }
                        try {
                            if (speicherArtOrt.isSynchronisieren()) {
                                RWService.getService().getEinstellungen().removeValue(new EinstellungsAdresse(null, String.valueOf(parameterID) + ID_ZEITPUNKT, speicher));
                            }
                        }
                        catch (Exception e) {
                            listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib.syncZeitPunkt", (String)String.format("Der Parameter <%s> kann nicht %s gel\u00f6scht werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt)), (Throwable)e));
                        }
                    } else {
                        listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gel\u00f6scht werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt))));
                    }
                    ++n2;
                }
            }
        }
        if (listeWarnungen.isEmpty()) {
            return true;
        }
        Log.zeige((IStatus)Log.erzeugeMultiMeldung((String)"de.inovat.buv.projektlib", (String)"Fehler beim Speichern des Parameters", listeWarnungen));
        return false;
    }

    @Deprecated
    public static boolean loescheParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt, UrlasserInfo urlasserInfo) {
        return SpeicherFunktionen.loescheParameter(parameterID, speicherArtOrt, new de.bsvrz.puk.param.lib.daten.UrlasserInfo(urlasserInfo.getBenutzer(), urlasserInfo.getPasswort(), urlasserInfo.getUrsache(), urlasserInfo.getVeranlasser()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loescheParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt, de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo) {
        ArrayList<IStatus> listeWarnungen = new ArrayList<IStatus>();
        Boolean bl = SPEICHER_PROZESS_SYNC;
        synchronized (bl) {
            if (parameterID != null) {
                ArtOrt[] artOrtArray = speicherArtOrt.getArArtOrt();
                int n = artOrtArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtOrt artOrt = artOrtArray[n2];
                    SpeicherKey speicher = SpeicherFunktionen.ermittleSpeicher(artOrt);
                    if (speicher != null) {
                        try {
                            RWService.getService().getEinstellungen().setValue(new EinstellungsAdresse(null, parameterID, speicher), null, urlasserInfo);
                        }
                        catch (Exception e) {
                            listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gel\u00f6scht werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt)), (Throwable)e));
                        }
                        if (speicherArtOrt.isSynchronisieren()) {
                            try {
                                RWService.getService().getEinstellungen().setValue(new EinstellungsAdresse(null, String.valueOf(parameterID) + ID_ZEITPUNKT, speicher), null, urlasserInfo);
                            }
                            catch (Exception e) {
                                listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib.syncZeitPunkt", (String)String.format("Der Parameter <%s> kann nicht %s gel\u00f6scht werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt)), (Throwable)e));
                            }
                        }
                    } else {
                        listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gel\u00f6scht werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt))));
                    }
                    ++n2;
                }
            }
        }
        if (listeWarnungen.isEmpty()) {
            return true;
        }
        Log.zeige((IStatus)Log.erzeugeMultiMeldung((String)"de.inovat.buv.projektlib", (String)"Fehler beim Speichern des Parameters", listeWarnungen));
        return false;
    }

    @Deprecated
    public static UrlasserInfo oeffneUrlasserDialog(String ursache) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            UrlasserDatenDialog dialog = new UrlasserDatenDialog(shell, (UrlasserDatenSender)new DefaultDatenSender(null));
            String benutzer = RWService.getService().getRw().getBenutzerName();
            dialog.setInitialBenutzer(benutzer);
            dialog.setInitialVeranlasser(benutzer);
            dialog.setInitialUrsache(ursache);
            if (dialog.open() == 0) {
                return dialog.getUrlasserInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static de.bsvrz.puk.param.lib.daten.UrlasserInfo oeffneUrlasserInfoDialog(String ursache) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            UrlasserInfoDatenDialog dialog = new UrlasserInfoDatenDialog(shell, (UrlasserInfoDatenSender)new DefaultUrlasserInfoDatenSender(null));
            String benutzer = RWService.getService().getRw().getBenutzerName();
            dialog.setInitialBenutzer(benutzer);
            dialog.setInitialVeranlasser(benutzer);
            dialog.setInitialUrsache(ursache);
            if (dialog.open() == 0) {
                return dialog.getUrlasserInfo();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IStatus speichere(String parameterID, SpeicherArtUndOrt speicherArtOrt, String wert, de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo) {
        ArrayList<IStatus> listeWarnungen = new ArrayList<IStatus>();
        Boolean bl = SPEICHER_PROZESS_SYNC;
        synchronized (bl) {
            if (parameterID != null && wert != null) {
                String datum = "" + System.currentTimeMillis();
                ArtOrt[] artOrtArray = speicherArtOrt.getArArtOrt();
                int n = artOrtArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtOrt artOrt = artOrtArray[n2];
                    SpeicherKey speicher = SpeicherFunktionen.ermittleSpeicher(artOrt);
                    if (speicher != null) {
                        try {
                            RWService.getService().getEinstellungen().setValue(new EinstellungsAdresse(null, parameterID, speicher), (Object)wert, urlasserInfo);
                        }
                        catch (Exception e) {
                            listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gespeichert werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt)), (Throwable)e));
                        }
                        if (speicherArtOrt.isSynchronisieren()) {
                            try {
                                RWService.getService().getEinstellungen().setValue(new EinstellungsAdresse(null, String.valueOf(parameterID) + ID_ZEITPUNKT, speicher), (Object)datum, urlasserInfo);
                            }
                            catch (Exception e) {
                                listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gespeichert werden!", String.valueOf(parameterID) + ID_ZEITPUNKT, SpeicherFunktionen.ermittleBeschreibung(artOrt)), (Throwable)e));
                            }
                        }
                    } else {
                        listeWarnungen.add(Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Der Parameter <%s> kann nicht %s gespeichert werden!", parameterID, SpeicherFunktionen.ermittleBeschreibung(artOrt))));
                    }
                    ++n2;
                }
            }
        }
        if (listeWarnungen.isEmpty()) {
            return null;
        }
        return Log.erzeugeMultiMeldung((String)"de.inovat.buv.projektlib", (String)"Fehler beim Speichern des Parameters", listeWarnungen);
    }

    public static boolean speichereParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt, String wert) {
        de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo = SpeicherFunktionen.oeffneUrlasserInfoDialog(String.format("\u00c4nderung des Einstellungsparameters <%s>", parameterID));
        return SpeicherFunktionen.speichereParameter(parameterID, speicherArtOrt, wert, urlasserInfo);
    }

    @Deprecated
    public static boolean speichereParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt, String wert, UrlasserInfo urlasserInfo) {
        return SpeicherFunktionen.speichereParameter(parameterID, speicherArtOrt, wert, new de.bsvrz.puk.param.lib.daten.UrlasserInfo(urlasserInfo.getBenutzer(), urlasserInfo.getPasswort(), urlasserInfo.getUrsache(), urlasserInfo.getVeranlasser()));
    }

    public static boolean speichereParameter(String parameterID, SpeicherArtUndOrt speicherArtOrt, String wert, de.bsvrz.puk.param.lib.daten.UrlasserInfo urlasserInfo) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IStatus meldung = urlasserInfo != null ? SpeicherFunktionen.speichere(parameterID, speicherArtOrt, wert, urlasserInfo) : Log.erzeugeMeldung((int)2, (String)"de.inovat.buv.projektlib", (String)String.format("Parameter <%s> wird nicht gespeichert (es fehlen die Urlasser-Daten)", parameterID));
        if (meldung != null) {
            Log.zeige((IStatus)meldung);
        }
        return meldung == null;
    }

    public static enum ArtOrt {
        ALLGEMEIN_LOKAL,
        ALLGEMEIN_DAV,
        BENUTZER_LOKAL,
        BENUTZER_DAV;

    }
}

